/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaAction;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Cacheable
@Table(name="META_MENU", indexes={@Index(columnList="name"), @Index(columnList="title"), @Index(columnList="parent"), @Index(columnList="action"), @Index(columnList="user_id")})
public class MetaMenu
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_MENU_SEQ")
    @SequenceGenerator(name="META_MENU_SEQ", sequenceName="META_MENU_SEQ", allocationSize=1)
    private Long id;
    private Integer priority = 0;
    @Widget(title="Menu order")
    @Column(name="order_seq")
    private Integer order = 0;
    @HashKey
    @Column(unique=true)
    private String xmlId;
    @NotNull
    private String name;
    @NameColumn
    @NotNull
    private String title;
    private String icon;
    private String iconBackground;
    private String module;
    @Widget(title="Tag label")
    private String tag;
    @Widget(title="Tag method")
    private String tagGet;
    @Widget(title="Tag count")
    private Boolean tagCount = Boolean.FALSE;
    @Widget(title="Tag style", selection="label.style.selection")
    private String tagStyle;
    @Widget(title="Top menu")
    @Column(name="top_menu")
    private Boolean top = Boolean.FALSE;
    @Widget(title="Left menu")
    @Column(name="left_menu")
    private Boolean left = Boolean.TRUE;
    @Widget(title="Mobile menu")
    @Column(name="mobile_menu")
    private Boolean mobile = Boolean.FALSE;
    @Widget(title="Hidden menu")
    private Boolean hidden = Boolean.FALSE;
    private String link;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaMenu parent;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaAction action;
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Group> groups;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @Widget(title="Condition to check", help="Only use this menu-item if the given expression is true (ie `if` condition).")
    @Size(max=1024)
    private String conditionToCheck;
    @Widget(title="Module to check", help="Only use this menu-item if the given module is installed (ie `if-module` condition).")
    private String moduleToCheck;

    public MetaMenu() {
    }

    public MetaMenu(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getOrder() {
        return this.order == null ? 0 : this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIconBackground() {
        return this.iconBackground;
    }

    public void setIconBackground(String iconBackground) {
        this.iconBackground = iconBackground;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTagGet() {
        return this.tagGet;
    }

    public void setTagGet(String tagGet) {
        this.tagGet = tagGet;
    }

    public Boolean getTagCount() {
        return this.tagCount == null ? Boolean.FALSE : this.tagCount;
    }

    public void setTagCount(Boolean tagCount) {
        this.tagCount = tagCount;
    }

    public String getTagStyle() {
        return this.tagStyle;
    }

    public void setTagStyle(String tagStyle) {
        this.tagStyle = tagStyle;
    }

    public Boolean getTop() {
        return this.top == null ? Boolean.FALSE : this.top;
    }

    public void setTop(Boolean top) {
        this.top = top;
    }

    public Boolean getLeft() {
        return this.left == null ? Boolean.FALSE : this.left;
    }

    public void setLeft(Boolean left) {
        this.left = left;
    }

    public Boolean getMobile() {
        return this.mobile == null ? Boolean.FALSE : this.mobile;
    }

    public void setMobile(Boolean mobile) {
        this.mobile = mobile;
    }

    public Boolean getHidden() {
        return this.hidden == null ? Boolean.FALSE : this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public MetaMenu getParent() {
        return this.parent;
    }

    public void setParent(MetaMenu parent) {
        this.parent = parent;
    }

    public MetaAction getAction() {
        return this.action;
    }

    public void setAction(MetaAction action) {
        this.action = action;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public void addGroup(Group item) {
        if (this.getGroups() == null) {
            this.setGroups(new HashSet<Group>());
        }
        this.getGroups().add(item);
    }

    public void removeGroup(Group item) {
        if (this.getGroups() == null) {
            return;
        }
        this.getGroups().remove(item);
    }

    public void clearGroups() {
        if (this.getGroups() != null) {
            this.getGroups().clear();
        }
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.getRoles() == null) {
            this.setRoles(new HashSet<Role>());
        }
        this.getRoles().add(item);
    }

    public void removeRole(Role item) {
        if (this.getRoles() == null) {
            return;
        }
        this.getRoles().remove(item);
    }

    public void clearRoles() {
        if (this.getRoles() != null) {
            this.getRoles().clear();
        }
    }

    public String getConditionToCheck() {
        return this.conditionToCheck;
    }

    public void setConditionToCheck(String conditionToCheck) {
        this.conditionToCheck = conditionToCheck;
    }

    public String getModuleToCheck() {
        return this.moduleToCheck;
    }

    public void setModuleToCheck(String moduleToCheck) {
        this.moduleToCheck = moduleToCheck;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaMenu)) {
            return false;
        }
        MetaMenu other = (MetaMenu)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getXmlId(), other.getXmlId());
    }

    public int hashCode() {
        return Objects.hash(-386041564, this.getXmlId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("priority", (Object)this.getPriority()).add("order", (Object)this.getOrder()).add("xmlId", (Object)this.getXmlId()).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("icon", (Object)this.getIcon()).add("iconBackground", (Object)this.getIconBackground()).add("module", (Object)this.getModule()).add("tag", (Object)this.getTag()).add("tagGet", (Object)this.getTagGet()).add("tagCount", (Object)this.getTagCount()).omitNullValues().toString();
    }
}

