/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Cacheable
@Table(name="META_MODEL", indexes={@Index(columnList="name")})
public class MetaModel
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_MODEL_SEQ")
    @SequenceGenerator(name="META_MODEL_SEQ", sequenceName="META_MODEL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Package")
    @NotNull
    private String packageName;
    @Widget(title="Table")
    private String tableName;
    @Widget(title="Fields")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="metaModel", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaField> metaFields;
    @Widget(title="Fullname")
    private String fullName;

    public MetaModel() {
    }

    public MetaModel(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<MetaField> getMetaFields() {
        return this.metaFields;
    }

    public void setMetaFields(List<MetaField> metaFields) {
        this.metaFields = metaFields;
    }

    public void addMetaField(MetaField item) {
        if (this.getMetaFields() == null) {
            this.setMetaFields(new ArrayList<MetaField>());
        }
        this.getMetaFields().add(item);
        item.setMetaModel(this);
    }

    public void removeMetaField(MetaField item) {
        if (this.getMetaFields() == null) {
            return;
        }
        this.getMetaFields().remove(item);
    }

    public void clearMetaFields() {
        if (this.getMetaFields() != null) {
            this.getMetaFields().clear();
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaModel)) {
            return false;
        }
        MetaModel other = (MetaModel)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("packageName", (Object)this.getPackageName()).add("tableName", (Object)this.getTableName()).add("fullName", (Object)this.getFullName()).omitNullValues().toString();
    }
}

