/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="META_MODULE")
public class MetaModule
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_MODULE_SEQ")
    @SequenceGenerator(name="META_MODULE_SEQ", sequenceName="META_MODULE_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @NotNull
    @Column(unique=true)
    private String name;
    @NotNull
    private String title;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Version")
    @NotNull
    private String moduleVersion;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="META_MODULE_DEPENDS", joinColumns={@JoinColumn(name="module_id")}, inverseJoinColumns={@JoinColumn(name="depend_id")})
    private Set<MetaModule> depends;
    private Boolean application = Boolean.FALSE;
    private Boolean removable = Boolean.FALSE;
    private Boolean installed = Boolean.FALSE;
    private Boolean pending = Boolean.FALSE;

    public MetaModule() {
    }

    public MetaModule(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(String moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public Set<MetaModule> getDepends() {
        return this.depends;
    }

    public void setDepends(Set<MetaModule> depends) {
        this.depends = depends;
    }

    public void addDepend(MetaModule item) {
        if (this.getDepends() == null) {
            this.setDepends(new HashSet<MetaModule>());
        }
        this.getDepends().add(item);
    }

    public void removeDepend(MetaModule item) {
        if (this.getDepends() == null) {
            return;
        }
        this.getDepends().remove(item);
    }

    public void clearDepends() {
        if (this.getDepends() != null) {
            this.getDepends().clear();
        }
    }

    public Boolean getApplication() {
        return this.application == null ? Boolean.FALSE : this.application;
    }

    public void setApplication(Boolean application) {
        this.application = application;
    }

    public Boolean getRemovable() {
        return this.removable == null ? Boolean.FALSE : this.removable;
    }

    public void setRemovable(Boolean removable) {
        this.removable = removable;
    }

    public Boolean getInstalled() {
        return this.installed == null ? Boolean.FALSE : this.installed;
    }

    public void setInstalled(Boolean installed) {
        this.installed = installed;
    }

    public Boolean getPending() {
        return this.pending == null ? Boolean.FALSE : this.pending;
    }

    public void setPending(Boolean pending) {
        this.pending = pending;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaModule)) {
            return false;
        }
        MetaModule other = (MetaModule)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(-1609814799, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("moduleVersion", (Object)this.getModuleVersion()).add("application", (Object)this.getApplication()).add("removable", (Object)this.getRemovable()).add("installed", (Object)this.getInstalled()).add("pending", (Object)this.getPending()).omitNullValues().toString();
    }
}

