/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.meta.db.MetaPermissionRule;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="META_PERMISSION")
public class MetaPermission
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_PERMISSION_SEQ")
    @SequenceGenerator(name="META_PERMISSION_SEQ", sequenceName="META_PERMISSION_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @NotNull
    @Column(unique=true)
    private String name;
    @NotNull
    private String object;
    private Boolean active = Boolean.TRUE;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="metaPermission", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaPermissionRule> rules;

    public MetaPermission() {
    }

    public MetaPermission(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Boolean getActive() {
        return this.active == null ? Boolean.FALSE : this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public List<MetaPermissionRule> getRules() {
        return this.rules;
    }

    public void setRules(List<MetaPermissionRule> rules) {
        this.rules = rules;
    }

    public void addRule(MetaPermissionRule item) {
        if (this.getRules() == null) {
            this.setRules(new ArrayList<MetaPermissionRule>());
        }
        this.getRules().add(item);
        item.setMetaPermission(this);
    }

    public void removeRule(MetaPermissionRule item) {
        if (this.getRules() == null) {
            return;
        }
        this.getRules().remove(item);
    }

    public void clearRules() {
        if (this.getRules() != null) {
            this.getRules().clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaPermission)) {
            return false;
        }
        MetaPermission other = (MetaPermission)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(1216709076, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("object", (Object)this.getObject()).add("active", (Object)this.getActive()).omitNullValues().toString();
    }
}

