/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaPermission;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="META_PERMISSION_RULE", uniqueConstraints={@UniqueConstraint(columnNames={"meta_permission", "field"})}, indexes={@Index(columnList="meta_permission")})
public class MetaPermissionRule
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_PERMISSION_RULE_SEQ")
    @SequenceGenerator(name="META_PERMISSION_RULE_SEQ", sequenceName="META_PERMISSION_RULE_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaPermission metaPermission;
    @NotNull
    private String field;
    @Widget(title="Read")
    private Boolean canRead = Boolean.FALSE;
    @Widget(title="Write")
    private Boolean canWrite = Boolean.FALSE;
    @Widget(title="Export")
    private Boolean canExport = Boolean.FALSE;
    private String readonlyIf;
    private String hideIf;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public MetaPermission getMetaPermission() {
        return this.metaPermission;
    }

    public void setMetaPermission(MetaPermission metaPermission) {
        this.metaPermission = metaPermission;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Boolean getCanRead() {
        return this.canRead == null ? Boolean.FALSE : this.canRead;
    }

    public void setCanRead(Boolean canRead) {
        this.canRead = canRead;
    }

    public Boolean getCanWrite() {
        return this.canWrite == null ? Boolean.FALSE : this.canWrite;
    }

    public void setCanWrite(Boolean canWrite) {
        this.canWrite = canWrite;
    }

    public Boolean getCanExport() {
        return this.canExport == null ? Boolean.FALSE : this.canExport;
    }

    public void setCanExport(Boolean canExport) {
        this.canExport = canExport;
    }

    public String getReadonlyIf() {
        return this.readonlyIf;
    }

    public void setReadonlyIf(String readonlyIf) {
        this.readonlyIf = readonlyIf;
    }

    public String getHideIf() {
        return this.hideIf;
    }

    public void setHideIf(String hideIf) {
        this.hideIf = hideIf;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaPermissionRule)) {
            return false;
        }
        MetaPermissionRule other = (MetaPermissionRule)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("field", (Object)this.getField()).add("canRead", (Object)this.getCanRead()).add("canWrite", (Object)this.getCanWrite()).add("canExport", (Object)this.getCanExport()).add("readonlyIf", (Object)this.getReadonlyIf()).add("hideIf", (Object)this.getHideIf()).omitNullValues().toString();
    }
}

