/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.meta.db.MetaScheduleParam;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="META_SCHEDULE")
public class MetaSchedule
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_SCHEDULE_SEQ")
    @SequenceGenerator(name="META_SCHEDULE_SEQ", sequenceName="META_SCHEDULE_SEQ", allocationSize=1)
    private Long id;
    private Boolean active = Boolean.FALSE;
    @HashKey
    @NotNull
    @Column(unique=true)
    private String name;
    private String description;
    @NotNull
    private String job;
    @NotNull
    private String cron;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="schedule", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaScheduleParam> params;

    public MetaSchedule() {
    }

    public MetaSchedule(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getActive() {
        return this.active == null ? Boolean.FALSE : this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public List<MetaScheduleParam> getParams() {
        return this.params;
    }

    public void setParams(List<MetaScheduleParam> params) {
        this.params = params;
    }

    public void addParam(MetaScheduleParam item) {
        if (this.getParams() == null) {
            this.setParams(new ArrayList<MetaScheduleParam>());
        }
        this.getParams().add(item);
        item.setSchedule(this);
    }

    public void removeParam(MetaScheduleParam item) {
        if (this.getParams() == null) {
            return;
        }
        this.getParams().remove(item);
    }

    public void clearParams() {
        if (this.getParams() != null) {
            this.getParams().clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaSchedule)) {
            return false;
        }
        MetaSchedule other = (MetaSchedule)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(-937456676, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("active", (Object)this.getActive()).add("name", (Object)this.getName()).add("description", (Object)this.getDescription()).add("job", (Object)this.getJob()).add("cron", (Object)this.getCron()).omitNullValues().toString();
    }
}

