/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaSelect;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Cacheable
@Table(name="META_SELECT_ITEM", indexes={@Index(columnList="title"), @Index(columnList="select_id")})
public class MetaSelectItem
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_SELECT_ITEM_SEQ")
    @SequenceGenerator(name="META_SELECT_ITEM_SEQ", sequenceName="META_SELECT_ITEM_SEQ", allocationSize=1)
    private Long id;
    @Widget(help="The select item title")
    @NameColumn
    @NotNull
    private String title;
    @Widget(help="The select item value")
    @NotNull
    private String value;
    @Widget(help="The image icon to show in UI widgets")
    private String icon;
    @Widget(help="The addition data for UI widgets")
    @Size(max=1024)
    private String data;
    @Column(name="order_seq")
    private Integer order = 0;
    private Boolean hidden = Boolean.FALSE;
    @NotNull
    @JoinColumn(name="select_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaSelect select;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Integer getOrder() {
        return this.order == null ? 0 : this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Boolean getHidden() {
        return this.hidden == null ? Boolean.FALSE : this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public MetaSelect getSelect() {
        return this.select;
    }

    public void setSelect(MetaSelect select) {
        this.select = select;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaSelectItem)) {
            return false;
        }
        MetaSelectItem other = (MetaSelectItem)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("title", (Object)this.getTitle()).add("value", (Object)this.getValue()).add("icon", (Object)this.getIcon()).add("data", (Object)this.getData()).add("order", (Object)this.getOrder()).add("hidden", (Object)this.getHidden()).omitNullValues().toString();
    }
}

