/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="META_SEQUENCE")
public class MetaSequence
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @HashKey
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String name;
    private String prefix;
    private String suffix;
    @NotNull
    private Integer padding = 0;
    @NotNull
    @Column(name="increment_by")
    private Integer increment = 1;
    @NotNull
    @Column(name="initial_value")
    private Long initial = 0L;
    @NotNull
    @Column(name="next_value")
    private Long next = 1L;

    public MetaSequence() {
    }

    public MetaSequence(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Integer getPadding() {
        return this.padding == null ? 0 : this.padding;
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public Integer getIncrement() {
        return this.increment == null ? 0 : this.increment;
    }

    public void setIncrement(Integer increment) {
        this.increment = increment;
    }

    public Long getInitial() {
        return this.initial == null ? 0L : this.initial;
    }

    public void setInitial(Long initial) {
        this.initial = initial;
    }

    public Long getNext() {
        return this.next == null ? 0L : this.next;
    }

    public void setNext(Long next) {
        this.next = next;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaSequence)) {
            return false;
        }
        MetaSequence other = (MetaSequence)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(1110012166, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("prefix", (Object)this.getPrefix()).add("suffix", (Object)this.getSuffix()).add("padding", (Object)this.getPadding()).add("increment", (Object)this.getIncrement()).add("initial", (Object)this.getInitial()).add("next", (Object)this.getNext()).omitNullValues().toString();
    }
}

