/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db.repo;

import com.axelor.db.EntityHelper;
import com.axelor.db.JpaRepository;
import com.axelor.db.Query;
import com.axelor.db.hibernate.type.JsonFunction;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.repo.MetaJsonModelRepository;
import com.axelor.rpc.Context;
import com.axelor.rpc.JsonContext;
import com.axelor.rpc.Resource;
import java.util.Map;
import java.util.Objects;

public class MetaJsonRecordRepository
extends JpaRepository<MetaJsonRecord> {
    public MetaJsonRecordRepository() {
        super(MetaJsonRecord.class);
    }

    public Context create(String jsonModel) {
        Objects.requireNonNull(jsonModel, "jsonModel cannot be null");
        MetaJsonRecord record = new MetaJsonRecord();
        record.setJsonModel(jsonModel);
        return this.create(record);
    }

    public Context create(MetaJsonRecord record) {
        Objects.requireNonNull(record, "record cannot be null");
        Objects.requireNonNull(record.getJsonModel(), "jsonModel cannot be null");
        MetaJsonContext context = new MetaJsonContext(record);
        context.put("jsonModel", (Object)record.getJsonModel());
        context.addChangeListener(evt -> record.setAttrs((String)context.get("attrs")));
        return context;
    }

    public MetaJsonRecord create(String jsonModel, Map<String, Object> values) {
        Context context = this.create(jsonModel);
        if (values != null) {
            context.putAll((Map<? extends String, ? extends Object>)values);
        }
        return EntityHelper.getEntity(context.asType(MetaJsonRecord.class));
    }

    @Override
    public MetaJsonRecord save(Context context) {
        if (context instanceof MetaJsonContext && ((MetaJsonContext)context).record != null) {
            return this.save(((MetaJsonContext)context).record);
        }
        return this.save(context.asType(MetaJsonRecord.class));
    }

    @Override
    public MetaJsonRecord save(MetaJsonRecord entity) {
        MetaJsonModelRepository models = Beans.get(MetaJsonModelRepository.class);
        MetaJsonModel model = models.findByName(entity.getJsonModel());
        if (model != null && model.getNameField() != null) {
            entity.setName((String)new JsonContext(entity).get(model.getNameField()));
        }
        return super.save(entity);
    }

    public MetaJsonRecordQuery all(String jsonModel) {
        return new MetaJsonRecordQuery(jsonModel);
    }

    public static class MetaJsonRecordQuery
    extends Query<MetaJsonRecord> {
        private final String jsonModel;

        public MetaJsonRecordQuery(String jsonModel) {
            super(MetaJsonRecord.class);
            this.jsonModel = jsonModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Query<MetaJsonRecord> filter(String filter, Object ... params) {
            try {
                Query<MetaJsonRecord> query = super.filter("(self.jsonModel = :jsonModel) AND (" + filter + ")", params);
                return query;
            }
            finally {
                this.bind("jsonModel", this.jsonModel);
            }
        }

        public Query<MetaJsonRecord> by(String field, String operator, Object value) {
            String path = field.startsWith("attrs.") ? field : "attrs." + field;
            JsonFunction func = JsonFunction.fromPath(path);
            StringBuilder builder = new StringBuilder(func.toString()).append(" ").append(operator).append(" ").append(":param");
            return this.filter(builder.toString()).bind("param", value);
        }

        public Query<MetaJsonRecord> by(String field, Object value) {
            return this.by(field, "=", value);
        }
    }

    private static class MetaJsonContext
    extends Context {
        private final MetaJsonRecord record;

        public MetaJsonContext(MetaJsonRecord record) {
            super(Resource.toMap(record, new String[0]), MetaJsonRecord.class);
            this.record = record;
        }
    }
}

