/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db.repo;

import com.axelor.db.JpaRepository;
import com.axelor.db.Query;
import com.axelor.meta.db.MetaView;

public class MetaViewRepository
extends JpaRepository<MetaView> {
    public MetaViewRepository() {
        super(MetaView.class);
    }

    public MetaView findByID(String xmlId) {
        return Query.of(MetaView.class).filter("self.xmlId = :xmlId").bind("xmlId", xmlId).fetchOne();
    }

    public MetaView findByName(String name) {
        return Query.of(MetaView.class).filter("self.name = :name AND COALESCE(self.extension, FALSE) = FALSE").bind("name", name).order("-priority").cacheable().fetchOne();
    }

    public MetaView findByNameAndComputed(String name, Boolean computed) {
        return Query.of(MetaView.class).filter("self.name = :name AND COALESCE(self.extension, FALSE) = FALSE\t   AND COALESCE(self.computed, FALSE) = :computed").bind("name", name).bind("computed", computed).order("-priority").cacheable().fetchOne();
    }

    public Query<MetaView> findByModule(String module) {
        return Query.of(MetaView.class).filter("self.module = :module").bind("module", module).cacheable();
    }

    public Query<MetaView> findByDependentModule(String module) {
        return Query.of(MetaView.class).filter("COALESCE(self.extension, FALSE) = FALSE\t   AND COALESCE(self.computed, FALSE) = FALSE\t   AND (self.dependentModules LIKE :module\t   OR self.dependentModules LIKE CONCAT('%,', :module, ',%')\t   OR self.dependentModules LIKE CONCAT(:module, ',%')\t   OR self.dependentModules LIKE CONCAT('%,', :module))").bind("module", module).order("id");
    }

    public Query<MetaView> findByDependentFeature(String feature) {
        return Query.of(MetaView.class).filter("COALESCE(self.extension, FALSE) = FALSE\t   AND COALESCE(self.computed, FALSE) = FALSE\t   AND (self.dependentFeatures LIKE :feature\t   OR self.dependentFeatures LIKE CONCAT('%,', :feature, ',%')\t   OR self.dependentFeatures LIKE CONCAT(:feature, ',%')\t   OR self.dependentFeatures LIKE CONCAT('%,', :feature))").bind("feature", feature).order("id");
    }

    public Query<MetaView> findHavingExtensionsByModule(String module, boolean update) {
        return Query.of(MetaView.class).filter("(:module IS NULL OR self.module = :module)\t   AND (:update = TRUE OR NOT EXISTS (\t   SELECT computedView FROM MetaView computedView\t   WHERE computedView.name = self.name AND self.computed = TRUE))\t   AND COALESCE(self.extension, FALSE) = FALSE\t   AND COALESCE(self.computed, FALSE) = FALSE\t   AND (self.name, self.priority)\t   IN (SELECT other.name, MAX(other.priority) FROM MetaView other\t   WHERE COALESCE(other.extension, FALSE) = FALSE AND COALESCE(other.computed, FALSE) = FALSE\t   GROUP BY name)\t   AND EXISTS (SELECT extensionView FROM MetaView extensionView\t   WHERE extensionView.name = self.name AND extensionView.extension = TRUE)").bind("module", module).bind("update", update).order("id");
    }
}

