/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.meta.loader.Module;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass().getSuperclass());
    private static final ThreadLocal<Set<String>> visited = new ThreadLocal();
    private static final ThreadLocal<Map<Class<?>, Multimap<String, Object>>> unresolved = new ThreadLocal();

    AbstractLoader() {
    }

    protected boolean isVisited(Class<?> type, String name) {
        if (visited.get() == null) {
            visited.set(Sets.newHashSet());
        }
        if (visited.get().contains(type + name)) {
            this.log.error("duplicate found: {}", (Object)name);
            return true;
        }
        visited.get().add(type + name);
        return false;
    }

    protected <T> void setUnresolved(Class<T> type, String unresolvedKey, T value) {
        Multimap mm;
        HashMap map = unresolved.get();
        if (map == null) {
            map = Maps.newHashMap();
            unresolved.set(map);
        }
        if ((mm = (Multimap)map.get(type)) == null) {
            mm = HashMultimap.create();
            map.put(value.getClass(), mm);
        }
        mm.put((Object)unresolvedKey, value);
    }

    protected <T> Set<T> resolve(Class<T> type, String unresolvedKey) {
        HashSet values = Sets.newHashSet();
        Map<Class<?>, Multimap<String, Object>> map = unresolved.get();
        if (map == null) {
            return values;
        }
        Multimap<String, Object> mm = map.get(type);
        if (mm == null) {
            return values;
        }
        for (Object item : mm.get((Object)unresolvedKey)) {
            values.add(item);
        }
        mm.removeAll((Object)unresolvedKey);
        return values;
    }

    protected Set<String> unresolvedKeys() {
        HashSet names = Sets.newHashSet();
        Map<Class<?>, Multimap<String, Object>> map = unresolved.get();
        if (map == null) {
            return names;
        }
        for (Multimap<String, Object> mm : map.values()) {
            names.addAll(mm.keySet());
        }
        return names;
    }

    protected abstract void doLoad(Module var1, boolean var2);

    void doLast(Module module, boolean update) {
    }

    static void doCleanUp() {
        visited.remove();
        unresolved.remove();
    }

    public final void load(Module module, boolean update) {
        this.doLoad(module, update);
    }
}

