/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.common.FileUtils;
import com.axelor.data.csv.CSVImporter;
import com.axelor.data.xml.XMLImporter;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.loader.AbstractLoader;
import com.axelor.meta.loader.Module;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.LineReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Singleton;

@Singleton
class DataLoader
extends AbstractLoader {
    private static final String DATA_DIR_NAME = "data-init";
    private static final String INPUT_DIR_NAME = "input";
    private static final String INPUT_CONFIG_NAME = "input-config.xml";
    private static Pattern patCsv = Pattern.compile("^\\<\\s*csv-inputs");
    private static Pattern patXml = Pattern.compile("^\\<\\s*xml-inputs");

    DataLoader() {
    }

    @Override
    protected void doLoad(Module module, boolean update) {
        File tmp = this.extract(module);
        if (tmp == null) {
            return;
        }
        try {
            File config = FileUtils.getFile((File)tmp, (String)this.getDirName(), (String[])new String[]{INPUT_CONFIG_NAME});
            if (this.isConfig(config, patCsv)) {
                this.importCsv(config);
            } else if (this.isConfig(config, patXml)) {
                this.importXml(config);
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.clean(tmp);
        }
    }

    private void importCsv(File config) {
        File data = FileUtils.getFile((File)config.getParentFile(), (String)INPUT_DIR_NAME, (String[])new String[0]);
        CSVImporter importer = new CSVImporter(config.getAbsolutePath(), data.getAbsolutePath(), null);
        importer.run();
    }

    private void importXml(File config) throws IOException {
        File data = FileUtils.getFile((File)config.getParentFile(), (String)INPUT_DIR_NAME, (String[])new String[0]);
        XMLImporter importer = new XMLImporter(config.getAbsolutePath(), data.getAbsolutePath());
        importer.run();
    }

    private boolean isConfig(File file, Pattern pattern) {
        try {
            FileReader reader = new FileReader(file);
            LineReader lines = new LineReader((Readable)reader);
            String line = null;
            while ((line = lines.readLine()) != null) {
                if (!pattern.matcher(line).find()) continue;
                return true;
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    protected String getDirName() {
        return DATA_DIR_NAME;
    }

    private File extract(Module module) {
        String dirName = this.getDirName();
        List<URL> files = MetaScanner.findAll(module.getName(), dirName, "(.+?)");
        if (files.isEmpty()) {
            return null;
        }
        File tmp = Files.createTempDir();
        for (URL file : files) {
            String name = file.toString();
            name = name.substring(name.lastIndexOf(dirName));
            try {
                this.copy(file.openStream(), tmp, name);
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream in, File toDir, String name) throws IOException {
        File dst = FileUtils.getFile((File)toDir, (String)name, (String[])new String[0]);
        Files.createParentDirs((File)dst);
        try (FileOutputStream out = new FileOutputStream(dst);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
    }

    private void clean(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.clean(child);
            }
            file.delete();
        } else if (file.exists()) {
            file.delete();
        }
    }
}

