/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.common.FileUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.db.MetaTranslation;
import com.axelor.meta.db.repo.MetaTranslationRepository;
import com.axelor.meta.loader.AbstractLoader;
import com.axelor.meta.loader.Module;
import com.axelor.meta.loader.ModuleManager;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.persist.Transactional;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nLoader
extends AbstractLoader {
    private Logger log = LoggerFactory.getLogger(I18nLoader.class);
    @Inject
    private MetaTranslationRepository translations;

    private <T> List<T> orderFiles(List<T> files) {
        ArrayList<Object> all = new ArrayList<Object>();
        ArrayList<T> custom = new ArrayList<T>();
        Pattern pattern = Pattern.compile(".*(?:custom_)([a-zA-Z_]+)\\.csv$");
        for (T file : files) {
            String name = file.toString();
            if (pattern.matcher(name).matches()) {
                custom.add(file);
                continue;
            }
            all.add(file);
        }
        all.addAll(custom);
        return all;
    }

    @Override
    protected void doLoad(Module module, boolean update) {
        List<URL> files = MetaScanner.findAll(module.getName(), "i18n", "(.*?)\\.csv");
        List<URL> sorted = this.orderFiles(files);
        for (URL resource : sorted) {
            try {
                InputStream is = resource.openStream();
                Throwable throwable = null;
                try {
                    this.log.debug("Load translation: {}", (Object)resource.getFile());
                    this.process(is, resource.getFile(), module.getName());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                this.log.error("Unable to import file: {}", (Object)resource.getFile());
            }
        }
    }

    @Transactional
    public void load(String importPath) {
        for (Module module : ModuleManager.getAll()) {
            if (Strings.isNullOrEmpty((String)importPath)) {
                this.doLoad(module, false);
                continue;
            }
            this.loadModule(module, importPath);
        }
    }

    private void loadModule(Module module, String importPath) {
        File moduleDir = FileUtils.getFile((String)importPath, (String[])new String[]{module.getName()});
        if (!moduleDir.exists() || !moduleDir.isDirectory() || moduleDir.listFiles() == null) {
            return;
        }
        this.log.debug("Load {} translations", (Object)module.getName());
        List<File> files = this.orderFiles(Arrays.asList(moduleDir.listFiles()));
        for (File file : files) {
            try {
                this.log.debug("Load {} translations", (Object)file.getPath());
                this.process(new FileInputStream(file), file.getPath(), module.getName());
            }
            catch (IOException e) {
                this.log.error("Unable to import file: {}", (Object)file.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(InputStream stream, String fileName, String moduleName) throws IOException {
        String language = "";
        Pattern pattern = Pattern.compile(".*(?:messages_|custom_)([a-zA-Z_]+)\\.csv$");
        Matcher matcher = pattern.matcher(fileName);
        if (!matcher.matches()) {
            return;
        }
        language = matcher.group(1);
        InputStreamReader reader = new InputStreamReader(stream, Charsets.UTF_8);
        try (CSVReader csvReader = new CSVReader((Reader)reader, ',', '\"', '\u0000');){
            String[] fields = csvReader.readNext();
            String[] values = null;
            int counter = 0;
            while ((values = csvReader.readNext()) != null) {
                if (this.isEmpty(values)) continue;
                Map<String, String> map = this.toMap(fields, values);
                String key = map.get("key");
                String message = map.get("message");
                if (StringUtils.isBlank((CharSequence)key)) continue;
                MetaTranslation entity = this.translations.findByKey(key, language);
                if (entity == null) {
                    entity = new MetaTranslation();
                    entity.setKey(key);
                    entity.setLanguage(language);
                    entity.setMessage(message);
                } else if (!StringUtils.isBlank((CharSequence)message)) {
                    entity.setMessage(message);
                }
                this.translations.save(entity);
                if (counter++ % 20 != 0) continue;
                JPA.em().flush();
                JPA.em().clear();
            }
        }
    }

    private Map<String, String> toMap(String[] fields, String[] values) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < fields.length; ++i) {
            map.put(fields[i], values[i]);
        }
        return map;
    }

    private boolean isEmpty(String[] line) {
        if (line == null || line.length == 0) {
            return true;
        }
        return line.length == 1 && (line[0] == null || "".equals(line[0].trim()));
    }
}

