/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.db.JPA;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.db.MetaEnum;
import com.axelor.meta.db.MetaSequence;
import com.axelor.meta.db.repo.MetaEnumRepository;
import com.axelor.meta.db.repo.MetaSequenceRepository;
import com.axelor.meta.loader.AbstractLoader;
import com.axelor.meta.loader.Module;
import com.axelor.meta.service.MetaModelService;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelLoader
extends AbstractLoader {
    private static Logger log = LoggerFactory.getLogger(ModelLoader.class);
    @Inject
    private MetaModelService service;
    @Inject
    private MetaSequenceRepository sequences;
    @Inject
    private MetaEnumRepository enums;

    @Override
    protected void doLoad(Module module, boolean update) {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return;
        }
        for (URL file : MetaScanner.findAll(module.getName(), "(domains|objects)", "(.*?)\\.xml$")) {
            log.debug("importing: {}", (Object)file.getFile());
            try {
                InputStream is = file.openStream();
                Throwable throwable = null;
                try {
                    Document doc = db.parse(is);
                    NodeList elements = doc.getDocumentElement().getChildNodes();
                    for (int i = 0; i < elements.getLength(); ++i) {
                        Node node = elements.item(i);
                        if (!(node instanceof Element)) continue;
                        Element element = (Element)elements.item(i);
                        String name = element.getTagName();
                        if ("enum".equals(name)) {
                            this.importEnums(element, update);
                        }
                        if ("entity".equals(name)) {
                            this.importModels(element, update);
                        }
                        if (!"sequence".equals(name)) continue;
                        this.importSequences(element, update);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static Set<String> findEntities(Module module) {
        DocumentBuilder db;
        HashSet<String> names = new HashSet<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return names;
        }
        for (URL file : MetaScanner.findAll(module.getName(), "(domains|objects)", "(.*?)\\.xml$")) {
            try {
                InputStream is = file.openStream();
                Throwable throwable = null;
                try {
                    Document doc = db.parse(is);
                    NodeList elements = doc.getElementsByTagName("entity");
                    for (int i = 0; i < elements.getLength(); ++i) {
                        Element element = (Element)elements.item(i);
                        names.add(element.getAttribute("name"));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return names;
    }

    private void importModels(Element element, boolean update) {
        String name = element.getAttribute("name");
        if ("Model".equals(name)) {
            return;
        }
        log.debug("Loading model: {}", (Object)name);
        this.service.process(JPA.model(name));
    }

    private void importEnums(Element element, boolean update) {
        Element module = (Element)element.getOwnerDocument().getElementsByTagName("module").item(0);
        String packageName = module.getAttribute("package");
        String name = element.getAttribute("name");
        String fullName = packageName + "." + name;
        log.debug("Loading enum: {}", (Object)fullName);
        MetaEnum found = this.enums.findByName(fullName);
        if (found == null) {
            found = new MetaEnum();
            found.setName(fullName);
        }
        this.enums.save(found);
    }

    private void importSequences(Element element, boolean update) {
        String name = element.getAttribute("name");
        if (this.isVisited(MetaSequence.class, name)) {
            return;
        }
        if (this.sequences.findByName(name) != null) {
            return;
        }
        log.debug("Loading sequence: {}", (Object)name);
        MetaSequence entity = new MetaSequence(name);
        entity.setPrefix(element.getAttribute("prefix"));
        entity.setSuffix(element.getAttribute("suffix"));
        Integer padding = Ints.tryParse((String)element.getAttribute("padding"));
        Integer increment = Ints.tryParse((String)element.getAttribute("increment"));
        Long initial = Longs.tryParse((String)element.getAttribute("initial"));
        if (padding != null) {
            entity.setPadding(padding);
        }
        if (increment != null) {
            entity.setIncrement(increment);
        }
        if (initial != null) {
            entity.setInitial(initial);
        }
        this.sequences.save(entity);
    }
}

