/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.auth.AuditableRunner;
import com.axelor.auth.AuthService;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.GroupRepository;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.common.StringUtils;
import com.axelor.db.internal.DBHelper;
import com.axelor.event.Event;
import com.axelor.event.NamedLiteral;
import com.axelor.events.ModuleChanged;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.db.MetaModule;
import com.axelor.meta.db.repo.MetaActionMenuRepository;
import com.axelor.meta.db.repo.MetaActionRepository;
import com.axelor.meta.db.repo.MetaMenuRepository;
import com.axelor.meta.db.repo.MetaModuleRepository;
import com.axelor.meta.db.repo.MetaSelectRepository;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.meta.loader.AbstractLoader;
import com.axelor.meta.loader.DataLoader;
import com.axelor.meta.loader.DemoLoader;
import com.axelor.meta.loader.I18nLoader;
import com.axelor.meta.loader.ModelLoader;
import com.axelor.meta.loader.Module;
import com.axelor.meta.loader.Resolver;
import com.axelor.meta.loader.ViewLoader;
import com.google.inject.persist.Transactional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static final Logger log = LoggerFactory.getLogger(ModuleManager.class);
    private static final Resolver resolver = new Resolver();
    private boolean loadData = true;
    @Inject
    private AuthService authService;
    @Inject
    private MetaModuleRepository modules;
    @Inject
    private ViewLoader viewLoader;
    @Inject
    private ModelLoader modelLoader;
    @Inject
    private I18nLoader i18nLoader;
    @Inject
    private DataLoader dataLoader;
    @Inject
    private DemoLoader demoLoader;
    @Inject
    private Event<ModuleChanged> moduleChangedEvent;
    private static final Set<String> SKIP = new HashSet<String>();

    public void initialize(boolean update, boolean withDemo) {
        try {
            this.createUsers();
            this.resolve(true);
            Beans.get(AuditableRunner.class).run(() -> {
                resolver.all().stream().filter(m -> !m.isRemovable() || m.isInstalled()).peek(m -> log.info("Loading package " + m.getName() + "...")).filter(m -> !m.isRemovable() || m.isPending()).forEach(m -> this.install(m.getName(), update, withDemo, false));
                resolver.all().stream().filter(Module::isInstalled).forEach(m -> this.viewLoader.doLast((Module)m, update));
                resolver.all().stream().filter(Module::isRemovable).filter(Module::isPending).filter(m -> !m.isInstalled()).map(Module::getName).forEach(this::uninstall);
            });
        }
        finally {
            this.encryptPasswords();
            this.doCleanUp();
        }
    }

    public void updateAll(boolean withDemo) {
        this.update(withDemo, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(boolean withDemo, String ... moduleNames) {
        ArrayList names = new ArrayList();
        if (moduleNames != null) {
            Collections.addAll(names, moduleNames);
        }
        try {
            this.createUsers();
            this.resolve(true);
            if (names.isEmpty()) {
                resolver.all().stream().filter(Module::isInstalled).map(Module::getName).forEach(names::add);
            }
            resolver.all().stream().filter(m -> names.contains(m.getName())).forEach(m -> this.install((Module)m, true, withDemo));
            resolver.all().stream().filter(m -> names.contains(m.getName())).forEach(m -> this.viewLoader.doLast((Module)m, true));
        }
        finally {
            this.doCleanUp();
        }
    }

    public void restoreMeta() {
        try {
            this.loadData = false;
            this.updateAll(false);
        }
        finally {
            this.loadData = true;
        }
    }

    public static List<String> getResolution() {
        return resolver.names();
    }

    static List<Module> getAll() {
        return resolver.all();
    }

    static Module getModule(String name) {
        return resolver.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(String moduleName, boolean update, boolean withDemo) {
        try {
            resolver.resolve(moduleName).stream().map(Module::getName).forEach(name -> this.install((String)name, update, withDemo, true));
            resolver.resolve(moduleName).stream().forEach(m -> this.viewLoader.doLast((Module)m, update));
        }
        finally {
            this.doCleanUp();
        }
    }

    @Transactional
    public void uninstall(String moduleName) {
        log.info("Removing package {}...", (Object)moduleName);
        MetaModule entity = this.modules.findByName(moduleName);
        Beans.get(MetaViewRepository.class).findByModule(moduleName).remove();
        Beans.get(MetaSelectRepository.class).findByModule(moduleName).remove();
        Beans.get(MetaMenuRepository.class).findByModule(moduleName).remove();
        Beans.get(MetaActionRepository.class).findByModule(moduleName).remove();
        Beans.get(MetaActionMenuRepository.class).findByModule(moduleName).remove();
        entity.setInstalled(false);
        entity.setPending(false);
        this.modules.save(entity);
        resolver.get(moduleName).setInstalled(false);
        resolver.get(moduleName).setPending(false);
        this.moduleChangedEvent.select(new Annotation[]{NamedLiteral.of(moduleName)}).fire(new ModuleChanged(moduleName, entity.getInstalled()));
    }

    private void doCleanUp() {
        AbstractLoader.doCleanUp();
    }

    private void install(String moduleName, boolean update, boolean withDemo, boolean force) {
        Module module = resolver.get(moduleName);
        MetaModule metaModule = this.modules.findByName(moduleName);
        if (metaModule == null) {
            return;
        }
        if (!module.isInstalled() && module.isRemovable() && !force) {
            return;
        }
        if (module.isInstalled() && !update && !module.isUpgradable() && !module.isPending()) {
            return;
        }
        this.install(module, update, withDemo);
        this.moduleChangedEvent.select(new Annotation[]{NamedLiteral.of(moduleName)}).fire(new ModuleChanged(moduleName, module.isInstalled()));
    }

    private void install(Module module, boolean update, boolean withDemo) {
        if (SKIP.contains(module.getName())) {
            return;
        }
        String message = "Installing package ";
        if (module.isInstalled()) {
            message = "Updating package ";
        }
        log.info(message + module + "...");
        this.installMeta(module, update);
        if (this.loadData) {
            this.dataLoader.load(module, update);
            if (withDemo) {
                this.demoLoader.load(module, update);
            }
        }
        this.updateState(module);
    }

    @Transactional
    void installMeta(Module module, boolean update) {
        this.modelLoader.load(module, update);
        this.viewLoader.load(module, update);
        this.i18nLoader.load(module, update);
    }

    @Transactional
    void updateState(Module module) {
        MetaModule metaModule = this.modules.findByName(module.getName());
        module.setInstalled(true);
        module.setPending(false);
        module.setInstalledVersion(module.getVersion());
        metaModule.setInstalled(true);
        metaModule.setPending(false);
    }

    public static boolean isInstalled(String module) {
        Module mod = resolver.get(module);
        return mod != null && mod.isInstalled();
    }

    private static Set<String> getInstalledModules() {
        HashSet<String> all = new HashSet<String>();
        try (Connection connection = DBHelper.getConnection();
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("select name from meta_module where installed = true");){
            while (rs.next()) {
                all.add(rs.getString("name"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return all;
    }

    public static List<String> findInstalled() {
        String name;
        Resolver resolver = new Resolver();
        Set<String> installed = ModuleManager.getInstalledModules();
        ArrayList<String> found = new ArrayList<String>();
        for (Properties properties : MetaScanner.findModuleProperties()) {
            name = properties.getProperty("name");
            if (SKIP.contains(name)) continue;
            String[] depends = properties.getProperty("depends", "").trim().split("\\s*,\\s*");
            String[] installs = properties.getProperty("installs", "").trim().split("\\s*,\\s*");
            boolean removable = "true".equals(properties.getProperty("removable"));
            boolean application = "true".equals(properties.getProperty("application"));
            Module module = resolver.add(name, depends);
            module.setRemovable(removable);
            module.setApplication(application);
            if (!installed.isEmpty()) continue;
            installed.addAll(Arrays.asList(installs));
        }
        for (Module module : resolver.all()) {
            name = module.getName();
            if (SKIP.contains(name)) continue;
            if (installed.contains(name)) {
                module.setInstalled(true);
            }
            if (!module.isInstalled() && module.isRemovable()) continue;
            found.add(name);
        }
        return found;
    }

    @Transactional
    void resolve(boolean update) {
        HashSet<String> forceInstall = new HashSet<String>();
        HashMap<MetaModule, String[]> dependencies = new HashMap<MetaModule, String[]>();
        boolean forceInit = this.modules.all().count() == 0L;
        for (Properties properties : MetaScanner.findModuleProperties()) {
            String name = properties.getProperty("name");
            if (SKIP.contains(name)) continue;
            String[] depends = properties.getProperty("depends", "").trim().split("\\s*,\\s*");
            String title = properties.getProperty("title");
            String description = properties.getProperty("description");
            String version = properties.getProperty("version");
            boolean removable = "true".equals(properties.getProperty("removable"));
            boolean application = "true".equals(properties.getProperty("application"));
            if (forceInit && forceInstall.isEmpty()) {
                String[] installs = properties.getProperty("installs", "").trim().split("\\s*,\\s*");
                forceInstall.addAll(Arrays.asList(installs));
            }
            Module module = resolver.add(name, depends);
            MetaModule stored = this.modules.findByName(name);
            if (stored == null) {
                stored = new MetaModule();
                stored.setName(name);
            }
            if (stored.getId() == null || update) {
                stored.setTitle(title);
                stored.setDescription(description);
                stored.setModuleVersion(version);
                stored.setRemovable(removable);
                stored.setApplication(application);
                stored = this.modules.save(stored);
                dependencies.put(stored, depends);
            }
            module.setVersion(version);
            module.setApplication(application);
            module.setRemovable(removable);
            module.setInstalled(stored.getInstalled() == Boolean.TRUE);
            module.setPending(stored.getPending() == Boolean.TRUE);
            module.setInstalledVersion(stored.getModuleVersion());
        }
        for (MetaModule stored : dependencies.keySet()) {
            HashSet<MetaModule> depends = new HashSet<MetaModule>();
            for (String name : (String[])dependencies.get(stored)) {
                if (StringUtils.isBlank((CharSequence)name)) continue;
                MetaModule depending = this.modules.findByName(name);
                if (depending == null) {
                    throw new RuntimeException("No such depemodule found: " + name + ", required by: " + stored.getName());
                }
                depends.add(depending);
            }
            stored.clearDepends();
            stored.setDepends(depends);
        }
        for (String name : forceInstall) {
            Module module = resolver.get(name);
            MetaModule stored = this.modules.findByName(name);
            if (module == null || stored == null) continue;
            module.setPending(stored.getInstalled() != Boolean.TRUE);
            stored.setPending(stored.getInstalled() != Boolean.TRUE);
            module.setInstalled(true);
            stored.setInstalled(true);
        }
    }

    @Transactional
    void createUsers() {
        UserRepository users = Beans.get(UserRepository.class);
        GroupRepository groups = Beans.get(GroupRepository.class);
        if (users.all().count() != 0L) {
            for (User user : users.all().filter("self.password not like :shiro").bind("shiro", "$shiro1$%").fetch()) {
                this.authService.encrypt(user);
            }
            return;
        }
        User admin = users.findByCode("admin");
        if (admin != null) {
            return;
        }
        Group adminGroup = groups.findByCode("admins");
        Group userGroup = groups.findByCode("users");
        if (adminGroup == null) {
            adminGroup = new Group("admins", "Administrators");
        }
        if (userGroup == null) {
            userGroup = new Group("users", "Users");
        }
        admin = new User("admin", "Administrator");
        admin.setPassword(this.authService.encrypt("admin"));
        admin.setGroup(adminGroup);
        try {
            Field createdBy = AuditableModel.class.getDeclaredField("createdBy");
            createdBy.setAccessible(true);
            createdBy.set(adminGroup, admin);
            createdBy.set(userGroup, admin);
            createdBy.set(admin, admin);
        }
        catch (Exception exception) {
            // empty catch block
        }
        admin = users.save(admin);
    }

    @Transactional
    public void encryptPasswords() {
        UserRepository users = Beans.get(UserRepository.class);
        if (users.all().count() != 0L) {
            for (User user : users.all().filter("self.password not like :shiro").bind("shiro", "$shiro1$%").fetch()) {
                this.authService.encrypt(user);
            }
        }
    }

    static {
        SKIP.add("axelor-common");
        SKIP.add("axelor-cglib");
        SKIP.add("axelor-test");
    }
}

