/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.common.StringUtils;
import com.axelor.meta.loader.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Resolver {
    private HashMap<String, Module> modules = new LinkedHashMap<String, Module>();

    Resolver() {
    }

    private Module module(String name) {
        Module module = this.modules.get(name);
        if (module == null) {
            module = new Module(name);
            this.modules.put(name, module);
        }
        return module;
    }

    private void resolve(String name, List<String> resolved, Set<String> unresolved) {
        Module module = this.modules.get(name);
        unresolved.add(name);
        if (module == null) {
            return;
        }
        for (Module dep : module.getDepends()) {
            if (resolved.contains(dep.getName())) continue;
            if (unresolved.contains(dep.getName())) {
                throw new IllegalArgumentException("Circular dependency detected: " + name + " -> " + dep.getName());
            }
            this.resolve(dep.getName(), resolved, unresolved);
        }
        resolved.add(name);
        unresolved.remove(name);
    }

    public Module add(String name, String ... depends) {
        Module module = this.module(name);
        Stream.of(depends).filter(StringUtils::notBlank).map(this::module).forEach(m -> module.dependsOn((Module)m));
        return module;
    }

    public List<Module> resolve(String name) {
        ArrayList<String> resolved = new ArrayList<String>();
        HashSet<String> unresolved = new HashSet<String>();
        this.resolve(name, resolved, unresolved);
        if (!unresolved.isEmpty()) {
            throw new IllegalArgumentException("Unresolved dependencies: " + unresolved);
        }
        return resolved.stream().map(this::module).collect(Collectors.toList());
    }

    public List<Module> all() {
        ArrayList<List<Module>> resolutions = new ArrayList<List<Module>>();
        ArrayList<Module> resolved = new ArrayList<Module>();
        for (String string : this.modules.keySet()) {
            resolutions.add(this.resolve(string));
        }
        for (List list : resolutions) {
            for (Module module : list) {
                if (resolved.contains(module)) continue;
                resolved.add(module);
            }
        }
        return resolved;
    }

    public List<String> names() {
        return this.all().stream().map(Module::getName).collect(Collectors.toList());
    }

    public Module get(String name) {
        return this.modules.get(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Module m : this.modules.values()) {
            builder.append(m.pprint(1)).append("\n\n");
        }
        return builder.toString();
    }
}

