/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.inject.Beans;
import com.axelor.meta.loader.ViewLoader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ViewWatcher {
    private static final Logger log = LoggerFactory.getLogger(ViewWatcher.class);
    private static ViewWatcher instance;
    private WatchService watcher;
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final List<ViewChangeEvent> pending = new ArrayList<ViewChangeEvent>();
    private Thread runner;
    private boolean running;

    private ViewWatcher() {
    }

    public static ViewWatcher getInstance() {
        if (instance == null) {
            instance = new ViewWatcher();
            instance.start();
        }
        return instance;
    }

    static synchronized void process() {
        ViewWatcher watcher = ViewWatcher.getInstance();
        if (watcher.pending.isEmpty()) {
            return;
        }
        ViewLoader loader = Beans.get(ViewLoader.class);
        try {
            watcher.pending.forEach(event -> {
                if (event.isDelete()) {
                    log.warn("File deleted: {}", (Object)event.getFile());
                } else {
                    log.info("Updating views from: {}", (Object)event.getFile());
                    try {
                        loader.updateFrom(event.getFile(), event.getModule());
                    }
                    catch (Exception e) {
                        log.error("Unable to update views from: {}", (Object)event.getFile(), (Object)e);
                    }
                }
            });
        }
        finally {
            watcher.pending.clear();
        }
    }

    private synchronized void addPending(ViewChangeEvent event) {
        if (this.pending.contains(event)) {
            this.pending.remove(event);
        }
        this.pending.add(0, event);
    }

    private boolean handleEvents() {
        WatchKey key;
        try {
            key = this.watcher.take();
        }
        catch (InterruptedException e) {
            return false;
        }
        Path dir = this.keys.get(key);
        if (dir == null) {
            return false;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
            Path file = dir.resolve((Path)event.context());
            Path module = dir.resolve(Paths.get("..", "..", "..", "..")).normalize();
            this.addPending(new ViewChangeEvent(kind, file, module.toFile().getName()));
        }
        boolean valid = key.reset();
        if (!valid) {
            this.keys.remove(key);
            if (this.keys.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private synchronized void registerAll() throws Exception {
        Pattern pattern = Pattern.compile(".*propertiesFilePath=([^,]+).*");
        Set<Path> paths = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().filter(s -> s.startsWith("-javaagent")).map(s -> pattern.matcher((CharSequence)s)).filter(m -> m.matches()).map(m -> m.group(1).trim()).map(x$0 -> Paths.get(x$0, new String[0])).flatMap(file -> {
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(file.toFile());){
                props.load(is);
            }
            catch (IOException e) {
                log.error("unable to read: {}", file, (Object)e);
                throw new UncheckedIOException(e);
            }
            String resources = props.getProperty("watchResources", "");
            return Stream.of(resources.split(","));
        }).map(String::trim).map(x$0 -> Paths.get(x$0, new String[0])).map(p -> p.resolve("views")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toSet());
        if (paths.isEmpty()) {
            return;
        }
        if (this.watcher == null) {
            this.watcher = FileSystems.getDefault().newWatchService();
        }
        log.info("Starting view watch...");
        paths.forEach(p -> {
            try {
                this.keys.put(p.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY), (Path)p);
                log.info("Watching: {}", p);
            }
            catch (IOException e) {
                log.warn("Unable to watch: {}", p);
            }
        });
    }

    public void start() {
        if (this.running) {
            return;
        }
        try {
            this.registerAll();
        }
        catch (Exception e) {
            log.error("Unable to start view watch.", (Throwable)e);
            return;
        }
        if (this.keys.isEmpty()) {
            return;
        }
        this.runner = new Thread(() -> {
            while (this.running && this.handleEvents()) {
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        this.running = true;
        this.runner.setDaemon(true);
        this.runner.start();
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            log.info("Stopping view watch....");
            this.keys.keySet().forEach(WatchKey::cancel);
            this.keys.clear();
        }
    }

    static final class ViewChangeEvent {
        private final WatchEvent.Kind<?> kind;
        private final Path file;
        private final String module;

        public ViewChangeEvent(WatchEvent.Kind<?> kind, Path file, String module) {
            this.kind = kind;
            this.file = file;
            this.module = module;
        }

        public boolean isCreate() {
            return this.kind == StandardWatchEventKinds.ENTRY_CREATE;
        }

        public boolean isDelete() {
            return this.kind == StandardWatchEventKinds.ENTRY_DELETE;
        }

        public boolean isModify() {
            return this.kind == StandardWatchEventKinds.ENTRY_MODIFY;
        }

        public WatchEvent.Kind<?> getKind() {
            return this.kind;
        }

        public Path getFile() {
            return this.file;
        }

        public String getModule() {
            return this.module;
        }

        public int hashCode() {
            return Objects.hash(0, this.file);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ViewChangeEvent)) {
                return false;
            }
            ViewChangeEvent other = (ViewChangeEvent)obj;
            return this.file.equals(other.file);
        }

        public String toString() {
            return "[" + this.kind + ", " + this.file + "]";
        }
    }
}

