/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.app.AppConfig;
import com.axelor.app.AppSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.Query;
import com.axelor.db.internal.DBHelper;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.MetaViewCustom;
import com.axelor.meta.db.repo.MetaActionRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.meta.db.repo.MetaViewCustomRepository;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.meta.loader.Module;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.meta.loader.ViewWatcher;
import com.axelor.meta.schema.ObjectViews;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.Position;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLViews {
    private static final Logger log = LoggerFactory.getLogger(XMLViews.class);
    private static final String LOCAL_SCHEMA = "object-views.xsd";
    private static final String REMOTE_SCHEMA = "object-views_" + ObjectViews.VERSION + ".xsd";
    private static final Set<String> VIEW_TYPES = new HashSet<String>();
    private static final String INDENT_STRING = "  ";
    private static final String[] INDENT_PROPERTIES = new String[]{"eclipselink.indent-string", "com.sun.xml.internal.bind.indentString", "com.sun.xml.bind.indentString"};
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static final XPathFactory XPATH_FACTORY;
    private static final NamespaceContext NS_CONTEXT;
    private static final Pattern NS_PATTERN;
    private static final LoadingCache<String, XPathExpression> XPATH_EXPRESSION_CACHE;
    private static final String APP_CONFIG_PROVIDER_KEY = "application.config.provider";
    private static AppConfig appConfigProvider;

    private XMLViews() {
    }

    private static void init() throws JAXBException, SAXException {
        if (unmarshaller != null) {
            return;
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectViews.class});
        unmarshaller = context.createUnmarshaller();
        marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.schemaLocation", (Object)("http://axelor.com/xml/ns/object-views http://axelor.com/xml/ns/object-views/" + REMOTE_SCHEMA));
        for (String string : INDENT_PROPERTIES) {
            try {
                marshaller.setProperty(string, (Object)INDENT_STRING);
                break;
            }
            catch (Exception e) {
                log.info("JAXB marshaller doesn't support property: {}", (Object)string);
            }
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(Resources.getResource((String)LOCAL_SCHEMA));
        unmarshaller.setSchema(schema);
        marshaller.setSchema(schema);
        JsonSubTypes types = AbstractView.class.getAnnotation(JsonSubTypes.class);
        for (JsonSubTypes.Type type : types.value()) {
            JsonTypeName name = type.value().getAnnotation(JsonTypeName.class);
            if (name == null) continue;
            VIEW_TYPES.add(name.value());
        }
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        String string = AppSettings.get().get(APP_CONFIG_PROVIDER_KEY);
        if (StringUtils.notBlank((CharSequence)string)) {
            try {
                Class<?> cls = Class.forName(string);
                appConfigProvider = (AppConfig)Beans.get(cls);
            }
            catch (ClassNotFoundException e) {
                log.error("Can't find class {} specified by {}", (Object)string, (Object)APP_CONFIG_PROVIDER_KEY);
            }
        }
        if (appConfigProvider == null) {
            appConfigProvider = featureName -> false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectViews unmarshal(InputStream stream) throws JAXBException {
        Unmarshaller unmarshaller = XMLViews.unmarshaller;
        synchronized (unmarshaller) {
            return (ObjectViews)XMLViews.unmarshaller.unmarshal(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectViews unmarshal(String xml) throws JAXBException {
        StringReader reader = new StringReader(XMLViews.prepareXML(xml));
        Unmarshaller unmarshaller = XMLViews.unmarshaller;
        synchronized (unmarshaller) {
            return (ObjectViews)XMLViews.unmarshaller.unmarshal((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectViews unmarshal(Node node) throws JAXBException {
        JAXBElement element;
        Unmarshaller unmarshaller = XMLViews.unmarshaller;
        synchronized (unmarshaller) {
            element = XMLViews.unmarshaller.unmarshal(node, ObjectViews.class);
        }
        return (ObjectViews)element.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void marshal(ObjectViews views, Writer writer) throws JAXBException {
        Marshaller marshaller = XMLViews.marshaller;
        synchronized (marshaller) {
            XMLViews.marshaller.marshal((Object)views, writer);
        }
    }

    public static Document parseXml(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(XMLViews.prepareXML(xml)));
        return documentBuilder.parse(is);
    }

    public static boolean isViewType(String type) {
        return VIEW_TYPES.contains(type);
    }

    private static String prepareXML(String xml) {
        StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='UTF-8'?>\n");
        sb.append("<object-views").append(" xmlns='").append("http://axelor.com/xml/ns/object-views").append("'").append(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'").append(" xsi:schemaLocation='").append("http://axelor.com/xml/ns/object-views").append(" ").append("http://axelor.com/xml/ns/object-views/" + REMOTE_SCHEMA).append("'").append(">\n").append(xml).append("\n</object-views>");
        return sb.toString();
    }

    private static String strip(String xml) {
        String[] lines = xml.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < lines.length - 1; ++i) {
            sb.append(lines[i] + "\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        return StringUtils.stripIndent((CharSequence)sb.toString());
    }

    public static String toXml(Object obj, boolean strip) {
        ObjectViews views = new ObjectViews();
        StringWriter writer = new StringWriter();
        if (obj instanceof Action) {
            views.setActions((List<Action>)ImmutableList.of((Object)((Action)obj)));
        }
        if (obj instanceof AbstractView) {
            views.setViews((List<AbstractView>)ImmutableList.of((Object)((AbstractView)obj)));
        }
        if (obj instanceof List) {
            views.setViews((List)obj);
        }
        try {
            XMLViews.marshal(views, writer);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        String text = writer.toString();
        if (strip) {
            text = XMLViews.strip(text);
        }
        return text;
    }

    public static ObjectViews fromXML(String xml) throws JAXBException {
        if (Strings.isNullOrEmpty((String)xml)) {
            return null;
        }
        if (!xml.trim().startsWith("<?xml")) {
            xml = XMLViews.prepareXML(xml);
        }
        StringReader reader = new StringReader(xml);
        return (ObjectViews)unmarshaller.unmarshal((Reader)reader);
    }

    public static void applyHotUpdates() {
        ViewWatcher.process();
    }

    public static Map<String, Object> findViews(String model, Map<String, String> views) {
        HashMap result = Maps.newHashMap();
        if (views == null || views.isEmpty()) {
            views = ImmutableMap.of((Object)"grid", (Object)"", (Object)"form", (Object)"");
        }
        for (Map.Entry<String, String> entry : views.entrySet()) {
            String type = entry.getKey();
            String name = entry.getValue();
            AbstractView view = XMLViews.findView(name, type, model);
            try {
                result.put(type, view);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private static MetaView findMetaView(MetaViewRepository views, String name, String type, String model, String module, Long group) {
        ArrayList<String> select = new ArrayList<String>();
        if (name != null) {
            select.add("self.name = :name");
        }
        if (type != null) {
            select.add("self.type = :type");
        }
        if (model != null) {
            select.add("self.model = :model");
        }
        if (module != null) {
            select.add("self.module = :module");
        }
        if (group == null) {
            select.add("self.groups is empty");
        } else {
            select.add("self.groups[].id = :group");
        }
        select.add("(self.extension is null OR self.extension = false)");
        return (MetaView)views.all().filter(Joiner.on((String)" AND ").join(select)).bind("name", name).bind("type", type).bind("model", model).bind("module", module).bind("group", group).cacheable().order("-priority").fetchOne();
    }

    public static AbstractView findView(String name, String type) {
        return XMLViews.findView(name, type, null, null);
    }

    public static AbstractView findView(String name, String type, String model) {
        return XMLViews.findView(name, type, model, null);
    }

    public static AbstractView findView(String name, String type, String model, String module) {
        AbstractView xmlView;
        MetaViewRepository views = Beans.get(MetaViewRepository.class);
        MetaViewCustomRepository customViews = Beans.get(MetaViewCustomRepository.class);
        User user = AuthUtils.getUser();
        Long group = user != null && user.getGroup() != null ? user.getGroup().getId() : null;
        MetaView view = null;
        MetaViewCustom custom = null;
        if (module == null && name != null && user != null) {
            custom = customViews.findByUser(name, model, user);
            custom = custom == null ? customViews.findByUser(name, user) : custom;
        }
        XMLViews.applyHotUpdates();
        if (StringUtils.notBlank((CharSequence)name)) {
            view = XMLViews.findMetaView(views, name, null, model, module, group);
            view = view == null ? XMLViews.findMetaView(views, name, null, null, module, group) : view;
            view = view == null ? XMLViews.findMetaView(views, name, null, model, module, null) : view;
            MetaView metaView = view = view == null ? XMLViews.findMetaView(views, name, null, null, module, null) : view;
            if (view == null) {
                log.error("No such view found: {}", (Object)name);
                return null;
            }
        }
        if (type != null && model != null) {
            view = view == null ? XMLViews.findMetaView(views, null, type, model, module, group) : view;
            view = view == null ? XMLViews.findMetaView(views, null, type, model, module, null) : view;
        }
        try {
            String xml;
            if (custom == null) {
                if (view == null) {
                    return null;
                }
                xml = view.getXml();
            } else {
                xml = custom.getXml();
            }
            ObjectViews objectViews = XMLViews.unmarshal(xml);
            xmlView = objectViews.getViews().get(0);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (view != null) {
            MetaModel metaModel;
            xmlView.setViewId(view.getId());
            xmlView.setHelpLink(view.getHelpLink());
            if (view.getModel() != null && (metaModel = (MetaModel)Beans.get(MetaModelRepository.class).all().filter("self.fullName = :name").bind("name", view.getModel()).cacheable().autoFlush(false).fetchOne()) != null) {
                xmlView.setModelId(metaModel.getId());
            }
        }
        return xmlView;
    }

    private static List<MetaView> findExtensionMetaViews(String name, String model, String type) {
        MetaViewRepository repo = Beans.get(MetaViewRepository.class);
        User user = AuthUtils.getUser();
        Long group = user != null && user.getGroup() != null ? user.getGroup().getId() : null;
        ArrayList<String> select = new ArrayList<String>();
        select.add("self.extension = true");
        select.add("self.name = :name");
        select.add("self.model = :model");
        select.add("self.type = :type");
        if (group == null) {
            select.add("self.groups is empty");
        } else {
            select.add("(self.groups is empty OR self.groups[].id = :group)");
        }
        return repo.all().filter(Joiner.on((String)" AND ").join(select)).bind("name", name).bind("model", model).bind("type", type).bind("group", group).cacheable().order("-priority").fetch();
    }

    public static Action findAction(String name) {
        XMLViews.applyHotUpdates();
        MetaAction metaAction = Beans.get(MetaActionRepository.class).findByName(name);
        try {
            Action action = XMLViews.unmarshal(metaAction.getXml()).getActions().get(0);
            action.setActionId(metaAction.getId());
            return action;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        XPATH_FACTORY = XPathFactory.newInstance();
        NS_CONTEXT = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return "http://axelor.com/xml/ns/object-views";
            }

            @Override
            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            public Iterator<Object> getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }
        };
        NS_PATTERN = Pattern.compile("/(\\w)");
        XPATH_EXPRESSION_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, XPathExpression>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public XPathExpression load(String key) throws Exception {
                XPath xPath;
                XPathFactory xPathFactory = XPATH_FACTORY;
                synchronized (xPathFactory) {
                    xPath = XPATH_FACTORY.newXPath();
                }
                xPath.setNamespaceContext(NS_CONTEXT);
                return xPath.compile(NS_PATTERN.matcher(key).replaceAll("/:$1"));
            }
        });
        try {
            XMLViews.init();
        }
        catch (JAXBException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    static class FinalViewGenerator {
        private static final int NUM_WORKERS = Runtime.getRuntime().availableProcessors();
        private static final int FETCH_INCREMENT = NUM_WORKERS * DBHelper.getJdbcFetchSize();
        private static final String STRING_DELIMITER = ",";
        private static final String TOOL_BAR = "toolbar";
        private static final String MENU_BAR = "menubar";
        private static final String PANEL_MAIL = "panel-mail";
        private static final Map<Position, Position> ROOT_NODE_POSITION_MAP = ImmutableMap.of((Object)((Object)Position.AFTER), (Object)((Object)Position.INSIDE_LAST), (Object)((Object)Position.BEFORE), (Object)((Object)Position.INSIDE_FIRST));
        @Inject
        private MetaViewRepository metaViewRepo;

        FinalViewGenerator() {
        }

        public void generate(MetaView view) {
            try {
                this.generateChecked(view);
            }
            catch (IOException | JAXBException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new RuntimeException(e);
            }
        }

        @Transactional(rollbackOn={Exception.class})
        public void generateChecked(MetaView view) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, JAXBException {
            MetaView originalView = this.getOriginalView(view);
            List<MetaView> extensionViews = FinalViewGenerator.findExtensionMetaViewsByModuleOrder(originalView);
            if (extensionViews.isEmpty()) {
                Optional.ofNullable(this.metaViewRepo.findByNameAndComputed(originalView.getName(), true)).ifPresent(this.metaViewRepo::remove);
                return;
            }
            String xml = originalView.getXml();
            Document document = XMLViews.parseXml(xml);
            Node viewNode = FinalViewGenerator.findViewNode(document);
            MetaView computedView = Optional.ofNullable(this.metaViewRepo.findByNameAndComputed(originalView.getName(), true)).orElseGet(() -> {
                MetaView copy = this.metaViewRepo.copy(originalView, false);
                copy.setComputed(true);
                this.metaViewRepo.persist(copy);
                return copy;
            });
            computedView.setPriority(originalView.getPriority() + 1);
            originalView.setDependentModules(null);
            originalView.setDependentFeatures(null);
            for (MetaView extensionView : extensionViews) {
                Document extensionDocument = XMLViews.parseXml(extensionView.getXml());
                Node extensionViewNode = FinalViewGenerator.findViewNode(extensionDocument);
                for (Node node : FinalViewGenerator.nodeListToList(extensionViewNode.getChildNodes())) {
                    if (!(node instanceof Element)) continue;
                    if ("extend".equals(node.getNodeName())) {
                        this.processExtend(document, node, originalView, extensionView);
                        continue;
                    }
                    FinalViewGenerator.processAppend(document, node, viewNode, originalView);
                }
            }
            ObjectViews objectViews = XMLViews.unmarshal(document);
            String finalXml = XMLViews.toXml(objectViews.getViews().get(0), true);
            computedView.setXml(finalXml);
            computedView.setModule(FinalViewGenerator.getLastModule(extensionViews));
        }

        @Nullable
        private static String getLastModule(List<MetaView> metaViews) {
            ListIterator<MetaView> it = metaViews.listIterator(metaViews.size());
            while (it.hasPrevious()) {
                String module = it.previous().getModule();
                if (!StringUtils.notBlank((CharSequence)module)) continue;
                return module;
            }
            return null;
        }

        private static List<MetaView> findExtensionMetaViewsByModuleOrder(MetaView view) {
            List views = XMLViews.findExtensionMetaViews(view.getName(), view.getModel(), view.getType());
            Map<String, List<MetaView>> viewsByModuleName = views.parallelStream().collect(Collectors.groupingBy(v -> Optional.ofNullable(v.getModule()).orElse("")));
            ArrayList<MetaView> result = new ArrayList<MetaView>(views.size());
            for (String string : ModuleManager.getResolution()) {
                result.addAll(viewsByModuleName.getOrDefault(string, Collections.emptyList()));
                viewsByModuleName.remove(string);
            }
            for (List list : viewsByModuleName.values()) {
                result.addAll(list);
            }
            return result;
        }

        private MetaView getOriginalView(MetaView view) {
            if (view.getComputed().booleanValue()) {
                log.warn("View is computed: {}", (Object)view.getName());
                return Optional.ofNullable(this.metaViewRepo.findByNameAndComputed(view.getName(), false)).orElseThrow(NoSuchElementException::new);
            }
            return view;
        }

        private static Node findViewNode(Document document) {
            return FinalViewGenerator.nodeListToStream(document.getFirstChild().getChildNodes()).filter(node -> node instanceof Element).findFirst().orElseThrow(NoSuchElementException::new);
        }

        private void processExtend(Document document, Node extensionNode, MetaView view, MetaView extensionView) throws XPathExpressionException {
            String target;
            Node targetNode;
            String module;
            Optional.ofNullable(ModuleManager.getModule(extensionView.getModule())).map(Module::isRemovable).filter(removable -> removable).ifPresent(removable -> FinalViewGenerator.addDependentModule(view, extensionView.getModule()));
            NamedNodeMap extendAttributes = extensionNode.getAttributes();
            String feature = FinalViewGenerator.getNodeAttributeValue(extendAttributes, "if-feature");
            if (StringUtils.notBlank((CharSequence)feature)) {
                FinalViewGenerator.addDependentFeature(view, feature);
                if (!appConfigProvider.hasFeature(feature)) {
                    return;
                }
            }
            if (StringUtils.notBlank((CharSequence)(module = FinalViewGenerator.getNodeAttributeValue(extendAttributes, "if-module")))) {
                FinalViewGenerator.addDependentModule(view, module);
                if (!ModuleManager.isInstalled(module)) {
                    return;
                }
            }
            if ((targetNode = (Node)FinalViewGenerator.evaluateXPath(target = FinalViewGenerator.getNodeAttributeValue(extendAttributes, "target"), view.getName(), view.getType(), document, XPathConstants.NODE)) == null) {
                log.error("View {}(id={}): extend target not found: {}", new Object[]{extensionView.getName(), extensionView.getXmlId(), target});
                return;
            }
            block12: for (Element extendItemElement : FinalViewGenerator.findElements(extensionNode.getChildNodes())) {
                switch (extendItemElement.getNodeName()) {
                    case "insert": {
                        FinalViewGenerator.doInsert(extendItemElement, targetNode, document, view);
                        continue block12;
                    }
                    case "replace": {
                        FinalViewGenerator.doReplace(extendItemElement, targetNode, document, view);
                        continue block12;
                    }
                    case "move": {
                        FinalViewGenerator.doMove(extendItemElement, targetNode, document, view, extensionView);
                        continue block12;
                    }
                    case "attribute": {
                        FinalViewGenerator.doAttribute(extendItemElement, targetNode);
                        continue block12;
                    }
                }
                log.error("View {}(id={}): unknown extension tag: {}", new Object[]{extensionView.getName(), extensionView.getXmlId(), extendItemElement.getNodeName()});
            }
        }

        private static void processAppend(Document document, Node extensionNode, Node viewNode, MetaView view) throws XPathExpressionException {
            Node node = document.importNode(extensionNode, true);
            Node panelMailNode = (Node)FinalViewGenerator.evaluateXPath(PANEL_MAIL, view.getName(), view.getType(), document, XPathConstants.NODE);
            if (panelMailNode == null) {
                viewNode.appendChild(node);
            } else {
                viewNode.insertBefore(node, panelMailNode);
            }
        }

        private static void doInsert(Node extendItemNode, Node targetNode, Document document, MetaView view) throws XPathExpressionException {
            List<Element> elements = FinalViewGenerator.findElements(extendItemNode.getChildNodes());
            List<Element> toolBarElements = FinalViewGenerator.filterElements(elements, TOOL_BAR);
            for (Element element : toolBarElements) {
                FinalViewGenerator.doInsertToolBar(element, document, view);
            }
            elements.removeAll(toolBarElements);
            List<Element> menuBarElements = FinalViewGenerator.filterElements(elements, MENU_BAR);
            for (Element element : menuBarElements) {
                FinalViewGenerator.doInsertMenuBar(element, document, view);
            }
            elements.removeAll(menuBarElements);
            List<Element> list = FinalViewGenerator.filterElements(elements, PANEL_MAIL);
            for (Element element : list) {
                FinalViewGenerator.doInsertPanelMail(element, document, view);
            }
            elements.removeAll(list);
            NamedNodeMap namedNodeMap = extendItemNode.getAttributes();
            String positionValue = FinalViewGenerator.getNodeAttributeValue(namedNodeMap, "position");
            Position position = Position.get(positionValue);
            if (FinalViewGenerator.isRootNode(targetNode)) {
                switch (position) {
                    case BEFORE: 
                    case INSIDE_FIRST: {
                        Node menuBarNode = (Node)FinalViewGenerator.evaluateXPath(MENU_BAR, view.getName(), view.getType(), document, XPathConstants.NODE);
                        if (menuBarNode != null) {
                            targetNode = menuBarNode;
                            position = Position.AFTER;
                            break;
                        }
                        Node toolBarNode = (Node)FinalViewGenerator.evaluateXPath(TOOL_BAR, view.getName(), view.getType(), document, XPathConstants.NODE);
                        if (toolBarNode != null) {
                            targetNode = toolBarNode;
                            position = Position.AFTER;
                            break;
                        }
                        position = Position.INSIDE_FIRST;
                        break;
                    }
                    case AFTER: 
                    case INSIDE_LAST: {
                        Node panelMailNode = (Node)FinalViewGenerator.evaluateXPath(PANEL_MAIL, view.getName(), view.getType(), document, XPathConstants.NODE);
                        if (panelMailNode != null) {
                            targetNode = panelMailNode;
                            position = Position.BEFORE;
                            break;
                        }
                        position = Position.INSIDE_LAST;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(position.toString());
                    }
                }
            }
            FinalViewGenerator.doInsert(elements, position, targetNode, document);
        }

        private static void doInsert(List<Element> elements, Position position, Node targetNode, Document document) {
            Node currentNode = targetNode;
            for (Element element : elements) {
                Node node = document.importNode(element, true);
                position.insert(currentNode, node);
                currentNode = node;
            }
        }

        private static void doInsertToolBar(Element element, Document document, MetaView view) throws XPathExpressionException {
            Position position;
            Node targetNode;
            Object elements;
            Node toolBarNode = (Node)FinalViewGenerator.evaluateXPath(TOOL_BAR, view.getName(), view.getType(), document, XPathConstants.NODE);
            if (toolBarNode != null) {
                elements = FinalViewGenerator.findElements(element.getChildNodes());
                targetNode = toolBarNode;
                position = Position.INSIDE_LAST;
            } else {
                elements = ImmutableList.of((Object)element);
                targetNode = (Node)FinalViewGenerator.evaluateXPath("/", view.getName(), view.getType(), document, XPathConstants.NODE);
                position = Position.INSIDE_FIRST;
            }
            FinalViewGenerator.doInsert((List<Element>)elements, position, targetNode, document);
        }

        private static void doInsertMenuBar(Element element, Document document, MetaView view) throws XPathExpressionException {
            Position position;
            Node targetNode;
            Object elements;
            Node menuBarNode = (Node)FinalViewGenerator.evaluateXPath(MENU_BAR, view.getName(), view.getType(), document, XPathConstants.NODE);
            if (menuBarNode != null) {
                elements = FinalViewGenerator.findElements(element.getChildNodes());
                targetNode = menuBarNode;
                position = Position.INSIDE_LAST;
            } else {
                elements = ImmutableList.of((Object)element);
                Node toolBarNode = (Node)FinalViewGenerator.evaluateXPath(TOOL_BAR, view.getName(), view.getType(), document, XPathConstants.NODE);
                if (toolBarNode != null) {
                    targetNode = toolBarNode;
                    position = Position.AFTER;
                } else {
                    targetNode = (Node)FinalViewGenerator.evaluateXPath("/", view.getName(), view.getType(), document, XPathConstants.NODE);
                    position = Position.INSIDE_FIRST;
                }
            }
            FinalViewGenerator.doInsert((List<Element>)elements, position, targetNode, document);
        }

        private static void doInsertPanelMail(Element element, Document document, MetaView view) throws XPathExpressionException {
            ImmutableList elements = ImmutableList.of((Object)element);
            Node panelMailNode = (Node)FinalViewGenerator.evaluateXPath(PANEL_MAIL, view.getName(), view.getType(), document, XPathConstants.NODE);
            if (panelMailNode != null) {
                FinalViewGenerator.doReplace((List<Element>)elements, panelMailNode, document);
                return;
            }
            Node targetNode = (Node)FinalViewGenerator.evaluateXPath("/", view.getName(), view.getType(), document, XPathConstants.NODE);
            Position position = Position.INSIDE_LAST;
            FinalViewGenerator.doInsert((List<Element>)elements, position, targetNode, document);
        }

        private static void doReplace(Node extendItemNode, Node targetNode, Document document, MetaView view) throws XPathExpressionException {
            List<Element> elements = FinalViewGenerator.findElements(extendItemNode.getChildNodes());
            List<Element> toolBarElements = FinalViewGenerator.filterElements(elements, TOOL_BAR);
            for (Element element : toolBarElements) {
                FinalViewGenerator.doReplaceToolBar(element, document, view);
            }
            elements.removeAll(toolBarElements);
            List<Element> menuBarElements = FinalViewGenerator.filterElements(elements, MENU_BAR);
            for (Element element : menuBarElements) {
                FinalViewGenerator.doReplaceMenuBar(element, document, view);
            }
            elements.removeAll(menuBarElements);
            List<Element> list = FinalViewGenerator.filterElements(elements, PANEL_MAIL);
            for (Element element : list) {
                FinalViewGenerator.doReplacePanelMail(element, document, view);
            }
            elements.removeAll(list);
            FinalViewGenerator.doReplace(elements, targetNode, document);
        }

        private static void doReplace(List<Element> elements, Node targetNode, Document document) {
            if (elements.isEmpty()) {
                targetNode.getParentNode().removeChild(targetNode);
            } else {
                Node node = document.importNode(elements.get(0), true);
                targetNode.getParentNode().replaceChild(node, targetNode);
                FinalViewGenerator.doInsert(elements.subList(1, elements.size()), Position.AFTER, node, document);
            }
        }

        private static void doReplaceToolBar(Element element, Document document, MetaView view) throws XPathExpressionException {
            ImmutableList elements = ImmutableList.of((Object)element);
            Node toolBarNode = (Node)FinalViewGenerator.evaluateXPath(TOOL_BAR, view.getName(), view.getType(), document, XPathConstants.NODE);
            if (toolBarNode != null) {
                FinalViewGenerator.doReplace((List<Element>)elements, toolBarNode, document);
                return;
            }
            Node targetNode = (Node)FinalViewGenerator.evaluateXPath("/", view.getName(), view.getType(), document, XPathConstants.NODE);
            Position position = Position.INSIDE_FIRST;
            FinalViewGenerator.doInsert((List<Element>)elements, position, targetNode, document);
        }

        private static void doReplaceMenuBar(Element element, Document document, MetaView view) throws XPathExpressionException {
            Position position;
            Node targetNode;
            ImmutableList elements = ImmutableList.of((Object)element);
            Node menuBarNode = (Node)FinalViewGenerator.evaluateXPath(MENU_BAR, view.getName(), view.getType(), document, XPathConstants.NODE);
            if (menuBarNode != null) {
                FinalViewGenerator.doReplace((List<Element>)elements, menuBarNode, document);
                return;
            }
            Node toolBarNode = (Node)FinalViewGenerator.evaluateXPath(TOOL_BAR, view.getName(), view.getType(), document, XPathConstants.NODE);
            if (toolBarNode != null) {
                targetNode = toolBarNode;
                position = Position.AFTER;
            } else {
                targetNode = (Node)FinalViewGenerator.evaluateXPath("/", view.getName(), view.getType(), document, XPathConstants.NODE);
                position = Position.INSIDE_FIRST;
            }
            FinalViewGenerator.doInsert((List<Element>)elements, position, targetNode, document);
        }

        private static void doReplacePanelMail(Element element, Document document, MetaView view) throws XPathExpressionException {
            ImmutableList elements = ImmutableList.of((Object)element);
            Node panelMailNode = (Node)FinalViewGenerator.evaluateXPath(PANEL_MAIL, view.getName(), view.getType(), document, XPathConstants.NODE);
            if (panelMailNode != null) {
                FinalViewGenerator.doReplace((List<Element>)elements, panelMailNode, document);
                return;
            }
            Node targetNode = (Node)FinalViewGenerator.evaluateXPath("/", view.getName(), view.getType(), document, XPathConstants.NODE);
            Position position = Position.INSIDE_LAST;
            FinalViewGenerator.doInsert((List<Element>)elements, position, targetNode, document);
        }

        private static void doMove(Node extendItemNode, Node targetNode, Document document, MetaView view, MetaView extensionView) throws XPathExpressionException {
            NamedNodeMap attributes = extendItemNode.getAttributes();
            String source = FinalViewGenerator.getNodeAttributeValue(attributes, "source");
            Node sourceNode = (Node)FinalViewGenerator.evaluateXPath(source, view.getName(), view.getType(), document, XPathConstants.NODE);
            if (sourceNode == null) {
                log.error("View {}(id={}): move source not found: {}", new Object[]{extensionView.getName(), extensionView.getXmlId(), sourceNode});
                return;
            }
            String positionValue = FinalViewGenerator.getNodeAttributeValue(attributes, "position");
            Position position = Position.get(positionValue);
            if (FinalViewGenerator.isRootNode(targetNode)) {
                position = ROOT_NODE_POSITION_MAP.getOrDefault((Object)position, Position.INSIDE_LAST);
            }
            position.insert(targetNode, sourceNode);
        }

        private static boolean isRootNode(Node node) {
            return Optional.ofNullable(node).map(Node::getParentNode).map(Node::getNodeName).orElse("").equals(ObjectViews.class.getAnnotation(XmlRootElement.class).name());
        }

        private static void doAttribute(Node extendItemNode, Node targetNode) {
            NamedNodeMap attributes = extendItemNode.getAttributes();
            String name = FinalViewGenerator.getNodeAttributeValue(attributes, "name");
            String value = FinalViewGenerator.getNodeAttributeValue(attributes, "value");
            if (!(targetNode instanceof Element)) {
                log.error("Can change attributes only on elements: {}", (Object)targetNode);
                return;
            }
            Element targetElement = (Element)targetNode;
            if (StringUtils.isEmpty((CharSequence)value)) {
                targetElement.removeAttribute(name);
            } else {
                targetElement.setAttribute(name, value);
            }
        }

        private static List<Element> findElements(NodeList nodeList) {
            return FinalViewGenerator.nodeListToStream(nodeList).filter(node -> node instanceof Element).map(node -> (Element)node).collect(Collectors.toList());
        }

        private static List<Element> filterElements(List<Element> elements, String nodeName) {
            return elements.stream().filter(element -> nodeName.equals(element.getNodeName())).collect(Collectors.toList());
        }

        public void parallelGenerate(Query<MetaView> query) {
            ExecutorService pool = Executors.newFixedThreadPool(NUM_WORKERS);
            for (int i = 0; i < NUM_WORKERS; ++i) {
                int startOffset = i * DBHelper.getJdbcFetchSize();
                pool.execute(() -> this.generate(query, startOffset, FETCH_INCREMENT));
            }
            FinalViewGenerator.shutdownAndAwaitTermination(pool);
        }

        public void generate(Query<MetaView> query) {
            this.generate(query, 0, DBHelper.getJdbcFetchSize());
        }

        private void generate(Query<MetaView> query, int startOffset, int increment) {
            List<MetaView> views;
            int offset = startOffset;
            while (!(views = query.fetch(DBHelper.getJdbcFetchSize(), offset)).isEmpty()) {
                this.generate(views);
                offset += increment;
            }
        }

        @Transactional
        public void generate(List<MetaView> views) {
            views.forEach(this::generate);
        }

        private static void shutdownAndAwaitTermination(ExecutorService pool) {
            pool.shutdown();
            try {
                while (!pool.awaitTermination(1L, TimeUnit.HOURS)) {
                    log.warn("Pool {} takes too long to terminate.", (Object)pool);
                }
            }
            catch (InterruptedException e) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }

        private static String getNodeAttributeValue(NamedNodeMap attributes, String name) {
            Node item = attributes.getNamedItem(name);
            return item != null ? item.getNodeValue() : "";
        }

        private static Object evaluateXPath(String subExpression, String name, String type, Object item, QName returnType) throws XPathExpressionException {
            return FinalViewGenerator.evaluateXPath(FinalViewGenerator.prepareXPathExpression(subExpression, name, type), item, returnType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object evaluateXPath(String expression, Object item, QName returnType) throws XPathExpressionException {
            XPathExpression xPathExpression;
            XPathExpression xPathExpression2 = xPathExpression = (XPathExpression)XPATH_EXPRESSION_CACHE.getUnchecked((Object)expression);
            synchronized (xPathExpression2) {
                return xPathExpression.evaluate(item, returnType);
            }
        }

        private static String prepareXPathExpression(String subExpression, String name, String type) {
            String rootExpr = "/:object-views/:%s[@name='%s']";
            String expr = subExpression.startsWith("/") ? subExpression.substring(1) : subExpression;
            return String.format(expr.isEmpty() ? "/:object-views/:%s[@name='%s']" : "/:object-views/:%s[@name='%s']/" + expr, type, name, expr);
        }

        private static Stream<Node> nodeListToStream(NodeList nodeList) {
            return FinalViewGenerator.nodeListToList(nodeList).stream();
        }

        private static List<Node> nodeListToList(final NodeList nodeList) {
            return new AbstractList<Node>(){

                @Override
                public int size() {
                    return nodeList.getLength();
                }

                @Override
                public Node get(int index) {
                    return Optional.ofNullable(nodeList.item(index)).orElseThrow(IndexOutOfBoundsException::new);
                }
            };
        }

        private static void addDependentFeature(MetaView view, String featureName) {
            Set<String> dependentFeatures = FinalViewGenerator.stringToSet(view.getDependentFeatures());
            dependentFeatures.add(featureName);
            view.setDependentFeatures(FinalViewGenerator.iterableToString(dependentFeatures));
        }

        private static void addDependentModule(MetaView view, String moduleName) {
            Set<String> dependentModules = FinalViewGenerator.stringToSet(view.getDependentModules());
            dependentModules.add(moduleName);
            view.setDependentModules(FinalViewGenerator.iterableToString(dependentModules));
        }

        private static Set<String> stringToSet(String text) {
            return StringUtils.isBlank((CharSequence)text) ? Sets.newHashSet() : Sets.newHashSet((Object[])text.split(STRING_DELIMITER));
        }

        private static String iterableToString(Iterable<? extends CharSequence> elements) {
            return String.join((CharSequence)STRING_DELIMITER, elements);
        }
    }
}

