/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.i18n.I18n;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.schema.actions.Action;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class ActionCondition
extends Action {
    @XmlElement(name="check")
    private List<Check> conditions;

    public List<Check> getConditions() {
        return this.conditions;
    }

    @Override
    public Object evaluate(ActionHandler handler) {
        HashMap errors = Maps.newHashMap();
        for (Check check : this.conditions) {
            String names = check.getField();
            String error = check.getLocalizedError();
            if (Strings.isNullOrEmpty((String)names) && Strings.isNullOrEmpty((String)error) && !check.test(handler)) {
                return false;
            }
            if (names == null) continue;
            if (!StringUtils.isBlank((CharSequence)error)) {
                error = handler.evaluate(ActionCondition.toExpression(error, true)).toString();
            }
            for (String field : names.split(",")) {
                if (Action.test(handler, check.getCondition(field = field.trim()))) {
                    errors.put(field, error);
                    continue;
                }
                errors.put(field, "");
            }
        }
        return ObjectUtils.isEmpty((Object)errors) ? Boolean.valueOf(true) : errors;
    }

    @Override
    protected Object wrapper(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (value instanceof Map) {
            result.put("errors", value);
            return result;
        }
        return value;
    }

    @XmlType
    public static class Check
    extends Action.Element {
        @XmlAttribute
        private String field;
        @XmlAttribute
        private String error;

        public String getCondition(String field) {
            String condition = this.getCondition();
            if (StringUtils.isBlank((CharSequence)condition) && !StringUtils.isBlank((CharSequence)field)) {
                return field + " == null";
            }
            return condition != null ? condition.trim() : condition;
        }

        public String getField() {
            return this.field;
        }

        public String getError() {
            return this.error;
        }

        public String getLocalizedError() {
            if (StringUtils.isBlank((CharSequence)this.error)) {
                if (StringUtils.isBlank((CharSequence)this.getCondition())) {
                    return I18n.get("Field is required.");
                }
                return I18n.get("Invalid field value.");
            }
            return I18n.get(this.error);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("field", (Object)this.field).add("error", (Object)this.getError()).add("condition", (Object)this.getCondition()).toString();
        }
    }
}

