/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.meta.ActionHandler;
import com.axelor.meta.schema.actions.Action;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class ActionMethod
extends Action {
    @XmlElement(name="call")
    private Call call;

    public Call getCall() {
        return this.call;
    }

    public void setCall(Call call) {
        this.call = call;
    }

    private boolean isRpc(String methodCall) {
        return Pattern.matches("(\\w+)\\((.*?)\\)", methodCall);
    }

    @Override
    protected Object evaluate(ActionHandler handler) {
        if (!this.call.test(handler)) {
            this.log.debug("action '{}' doesn't meet the condition: {}", (Object)this.getName(), (Object)this.call.getCondition());
            return null;
        }
        if (this.isRpc(this.call.getMethod())) {
            return handler.rpc(this.call.getController(), this.call.getMethod());
        }
        return handler.call(this.call.getController(), this.call.getMethod());
    }

    @XmlType
    public static class Call
    extends Action.Element {
        @XmlAttribute
        private String method;
        @XmlAttribute(name="class")
        private String controller;

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getController() {
            return this.controller;
        }

        public void setController(String controller) {
            this.controller = controller;
        }
    }
}

