/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.common.StringUtils;
import com.axelor.i18n.I18n;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.actions.ActionResumable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class ActionValidate
extends ActionResumable {
    @JsonIgnore
    @XmlElements(value={@XmlElement(name="error", type=Error.class), @XmlElement(name="alert", type=Alert.class), @XmlElement(name="info", type=Info.class), @XmlElement(name="notify", type=Notify.class)})
    private List<Validator> validators;

    public List<Validator> getValidators() {
        return this.validators;
    }

    public void setValidators(List<Validator> validators) {
        this.validators = validators;
    }

    @Override
    protected ActionValidate copy() {
        ActionValidate action = new ActionValidate();
        ArrayList<Validator> items = new ArrayList<Validator>(this.validators);
        action.setName(this.getName());
        action.setModel(this.getModel());
        action.setValidators(items);
        return action;
    }

    @Override
    public Object evaluate(ActionHandler handler) {
        ArrayList info = Lists.newArrayList();
        ArrayList notify = Lists.newArrayList();
        HashMap result = Maps.newHashMap();
        for (int i = this.getIndex(); i < this.validators.size(); ++i) {
            Validator validator = this.validators.get(i);
            if (!validator.test(handler)) continue;
            String key = validator.getClass().getSimpleName().toLowerCase();
            String value = I18n.get(validator.getMessage());
            if (!StringUtils.isBlank((CharSequence)value)) {
                value = handler.evaluate(ActionValidate.toExpression(value, true)).toString();
            }
            if (validator instanceof Info) {
                info.add(value);
                continue;
            }
            if (validator instanceof Notify) {
                notify.add(value);
                continue;
            }
            result.put(key, value);
            if (!StringUtils.isBlank((CharSequence)validator.getAction())) {
                result.put("action", validator.getAction());
            }
            if (i + 1 < this.validators.size() && validator instanceof Alert) {
                result.put("pending", String.format("%s[%d]", this.getName(), i + 1));
            }
            if (!info.isEmpty()) {
                result.put("info", info);
            }
            if (!notify.isEmpty()) {
                result.put("notify", notify);
            }
            return result;
        }
        if (!info.isEmpty()) {
            result.put("info", info);
        }
        if (!notify.isEmpty()) {
            result.put("notify", notify);
        }
        return result.isEmpty() ? null : result;
    }

    @XmlType
    public static class Notify
    extends Validator {
    }

    @XmlType
    public static class Info
    extends Validator {
    }

    @XmlType
    public static class Alert
    extends Validator {
    }

    @XmlType
    public static class Error
    extends Validator {
    }

    public static class Validator
    extends Action.Element {
        @XmlAttribute(name="message")
        private String message;
        @XmlAttribute(name="action")
        private String action;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }
    }
}

