/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import com.axelor.app.internal.AppFilter;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Query;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaHelpRepository;
import com.axelor.meta.schema.views.CalendarView;
import com.axelor.meta.schema.views.CardsView;
import com.axelor.meta.schema.views.ChartView;
import com.axelor.meta.schema.views.CustomView;
import com.axelor.meta.schema.views.Dashboard;
import com.axelor.meta.schema.views.FormView;
import com.axelor.meta.schema.views.GanttView;
import com.axelor.meta.schema.views.GridView;
import com.axelor.meta.schema.views.KanbanView;
import com.axelor.meta.schema.views.Search;
import com.axelor.meta.schema.views.SearchFilters;
import com.axelor.meta.schema.views.TreeView;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSubTypes(value={@JsonSubTypes.Type(value=GridView.class), @JsonSubTypes.Type(value=FormView.class), @JsonSubTypes.Type(value=TreeView.class), @JsonSubTypes.Type(value=ChartView.class), @JsonSubTypes.Type(value=CalendarView.class), @JsonSubTypes.Type(value=GanttView.class), @JsonSubTypes.Type(value=CardsView.class), @JsonSubTypes.Type(value=KanbanView.class), @JsonSubTypes.Type(value=CustomView.class), @JsonSubTypes.Type(value=Dashboard.class), @JsonSubTypes.Type(value=Search.class), @JsonSubTypes.Type(value=SearchFilters.class)})
public abstract class AbstractView {
    @XmlAttribute(name="id")
    private String xmlId;
    @XmlTransient
    @JsonProperty
    private Long viewId;
    @XmlTransient
    @JsonProperty
    private Long modelId;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String title;
    @XmlAttribute
    private String css;
    @XmlAttribute
    private String model;
    @XmlAttribute
    private Boolean editable;
    @XmlAttribute
    private String groups;
    @XmlAttribute
    private String helpLink;
    @XmlAttribute
    private Boolean extension;
    @JsonIgnore
    @XmlAttribute(name="width")
    private String widthSpec;
    @XmlTransient
    @JsonIgnore
    private transient AbstractView owner;

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public Long getViewId() {
        return this.viewId;
    }

    public void setViewId(Long viewId) {
        this.viewId = viewId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonGetter(value="title")
    public String getLocalizedTitle() {
        return I18n.get(this.title);
    }

    @JsonIgnore
    public String getTitle() {
        return this.title;
    }

    @JsonSetter
    public void setTitle(String title) {
        this.title = title;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public void setWidthSpec(String widthSpec) {
        this.widthSpec = widthSpec;
    }

    public String getModel() {
        if (this.model != null) {
            return this.model;
        }
        MetaView view = Query.of(MetaView.class).filter("self.name = ?1", this.name).fetchOne();
        if (view != null && view.getModel() != null) {
            this.model = view.getModel();
        }
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }

    public Boolean getExtension() {
        return this.extension;
    }

    public void setExtension(Boolean extension) {
        this.extension = extension;
    }

    private String widthPart(int which) {
        if (Strings.isNullOrEmpty((String)this.widthSpec)) {
            return null;
        }
        String[] parts = this.widthSpec.split(":");
        if (which >= parts.length) {
            return null;
        }
        String part = parts[which];
        if (part.matches("\\d+")) {
            part = part + "px";
        }
        return part;
    }

    public String getWidth() {
        return this.widthPart(0);
    }

    public String getMinWidth() {
        return this.widthPart(1);
    }

    public String getMaxWidth() {
        return this.widthPart(2);
    }

    public AbstractView getOwner() {
        return this.owner;
    }

    public void setOwner(AbstractView owner) {
        this.owner = owner;
    }

    @XmlTransient
    public String getType() {
        try {
            return this.getClass().getAnnotation(JsonTypeName.class).value();
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    @XmlTransient
    @JsonProperty(value="helpOverride")
    public List<?> getHelpOverride() {
        if (AuthUtils.getUser() != null && AuthUtils.getUser().getNoHelp() == Boolean.TRUE) {
            return null;
        }
        MetaHelpRepository repo = Beans.get(MetaHelpRepository.class);
        String lang = AppFilter.getLocale() == null ? "en" : AppFilter.getLocale().getLanguage();
        List<Map> found = repo.all().filter("self.model = :model AND self.language = :lang and (self.view = :view OR self.view IS NULL)").bind("model", this.getModel()).bind("lang", lang).bind("view", this.getName()).order("-view").select("field", "type", "help", "style").fetch(-1, 0);
        return found.isEmpty() ? null : found;
    }
}

