/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import com.axelor.common.StringUtils;
import com.axelor.db.mapper.Mapper;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.FormView;
import com.axelor.meta.schema.views.GridView;
import com.axelor.meta.schema.views.Hilite;
import com.axelor.meta.schema.views.SimpleWidget;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType
@JsonTypeName(value="field")
public class Field
extends SimpleWidget {
    @XmlAttribute(name="type")
    private String serverType;
    @XmlAttribute
    private String placeholder;
    @XmlAttribute
    private String widget;
    @XmlAttribute
    private Boolean canSuggest;
    @XmlAttribute
    private String canSelect;
    @XmlAttribute
    private String canNew;
    @XmlAttribute
    private String canView;
    @XmlAttribute
    private String canEdit;
    @XmlAttribute
    private String canRemove;
    @XmlAttribute
    private String onChange;
    @XmlAttribute
    private String onSelect;
    @XmlAttribute
    private String target;
    @XmlAttribute(name="target-name")
    private String targetName;
    @XmlAttribute
    private String domain;
    @XmlAttribute
    private Boolean required;
    @XmlAttribute
    private String requiredIf;
    @XmlAttribute
    private String validIf;
    @XmlAttribute(name="min")
    private String minSize;
    @XmlAttribute(name="max")
    private String maxSize;
    @XmlAttribute
    private String pattern;
    @XmlAttribute
    private String fgColor;
    @XmlAttribute
    private String bgColor;
    @XmlAttribute
    private String selection;
    @XmlAttribute(name="selection-in")
    private String selectionIn;
    @XmlAttribute
    private String aggregate;
    @XmlAttribute
    private Boolean massUpdate;
    @XmlAttribute
    private Boolean sortable;
    @XmlAttribute(name="edit-window")
    private String editWindow;
    @XmlAttribute(name="form-view")
    private String formView;
    @XmlAttribute(name="grid-view")
    private String gridView;
    @XmlAttribute(name="summary-view")
    private String summaryView;
    @XmlAttribute(name="x-bind")
    private String bind;
    @XmlAttribute(name="x-enum-type")
    private String enumType;
    @XmlAttribute(name="x-related")
    private String related;
    @XmlAttribute(name="x-create")
    private String create;
    @XmlAttribute(name="x-can-reload")
    private Boolean canReload;
    @XmlAttribute(name="x-call-onSave")
    private Boolean callOnSave;
    @XmlAttribute(name="x-icon")
    private String icon;
    @XmlAttribute(name="x-icon-hover")
    private String iconHover;
    @XmlAttribute(name="x-icon-active")
    private String iconActive;
    @XmlAttribute(name="x-exclusive")
    private Boolean exclusive;
    @XmlAttribute(name="x-show-icons")
    private String showIcons;
    @XmlAttribute(name="x-direction")
    private String direction;
    @XmlAttribute(name="x-code-syntax")
    private String codeSyntax;
    @XmlAttribute(name="x-code-theme")
    private String codeTheme;
    @XmlAttribute(name="x-lite")
    private Boolean lite;
    @XmlAttribute(name="x-labels")
    private Boolean labels;
    @XmlAttribute(name="x-order")
    private String orderBy;
    @XmlAttribute(name="x-limit")
    private Integer limit;
    @XmlAttribute(name="x-search-limit")
    private Integer searchLimit;
    @XmlAttribute(name="x-accept")
    private String accept;
    @XmlAttribute(name="x-json-model")
    private String jsonModel;
    @XmlElement(name="hilite")
    private List<Hilite> hilites;
    @XmlElements(value={@XmlElement(name="form", type=FormView.class), @XmlElement(name="grid", type=GridView.class)})
    private List<AbstractView> views;

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    @JsonGetter(value="placeholder")
    public String getLocalizedPlaceholder() {
        return I18n.get(this.placeholder);
    }

    @JsonIgnore
    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getWidget() {
        return this.widget;
    }

    public void setWidget(String widget) {
        this.widget = widget;
    }

    public Boolean getCanSuggest() {
        return this.canSuggest;
    }

    public void setCanSuggest(Boolean canSuggest) {
        this.canSuggest = canSuggest;
    }

    public String getCanSelect() {
        return this.canSelect;
    }

    public void setCanSelect(String canSelect) {
        this.canSelect = canSelect;
    }

    public String getCanNew() {
        return this.canNew;
    }

    public void setCanNew(String canNew) {
        this.canNew = canNew;
    }

    public String getCanView() {
        return this.canView;
    }

    public void setCanView(String canView) {
        this.canView = canView;
    }

    public String getCanEdit() {
        return this.canEdit;
    }

    public void setCanEdit(String canEdit) {
        this.canEdit = canEdit;
    }

    public String getCanRemove() {
        return this.canRemove;
    }

    public void setCanRemove(String canRemove) {
        this.canRemove = canRemove;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public String getOnSelect() {
        return this.onSelect;
    }

    public void setOnSelect(String onSelect) {
        this.onSelect = onSelect;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getTarget() {
        if (this.target == null) {
            return this.getTargetModel();
        }
        return this.target;
    }

    public String getTargetName() {
        if (this.targetName != null) {
            return this.targetName;
        }
        String targetModel = this.getTarget();
        if (targetModel == null) {
            return null;
        }
        try {
            return Mapper.of(Class.forName(targetModel)).getNameField().getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getRequiredIf() {
        return this.requiredIf;
    }

    public void setRequiredIf(String requiredIf) {
        this.requiredIf = requiredIf;
    }

    public String getValidIf() {
        return this.validIf;
    }

    public void setValidIf(String validIf) {
        this.validIf = validIf;
    }

    public String getSelection() {
        return this.selection;
    }

    public String getSelectionIn() {
        return this.selectionIn;
    }

    public void setSelectionIn(String selectionIn) {
        this.selectionIn = selectionIn;
    }

    public List<?> getSelectionList() {
        String typeName;
        String string = typeName = StringUtils.isBlank((CharSequence)this.enumType) && "enum".equals(this.serverType) ? this.target : this.enumType;
        if (StringUtils.notBlank((CharSequence)typeName)) {
            try {
                return MetaStore.getSelectionList(Class.forName(typeName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("No such enum type found: " + typeName, e);
            }
        }
        return MetaStore.getSelectionList(this.getSelection());
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public String getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(String aggregate) {
        this.aggregate = aggregate;
    }

    public Boolean getMassUpdate() {
        return this.massUpdate;
    }

    public void setMassUpdate(Boolean massUpdate) {
        this.massUpdate = massUpdate;
    }

    public Boolean getSortable() {
        return this.sortable;
    }

    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public String getBind() {
        return this.bind;
    }

    public String getEnumType() {
        return this.enumType;
    }

    public String getRelated() {
        if (StringUtils.isBlank((CharSequence)this.related) && StringUtils.notBlank((CharSequence)this.widget) && this.widget.matches("RefSelect|ref-select")) {
            return this.getName() + "Id";
        }
        return this.related;
    }

    public String getCreate() {
        return this.create;
    }

    public Boolean getCanReload() {
        return this.canReload;
    }

    public void setCanReload(Boolean canReload) {
        this.canReload = canReload;
    }

    public Boolean getCallOnSave() {
        return this.callOnSave;
    }

    public void setCallOnSave(Boolean callOnSave) {
        this.callOnSave = callOnSave;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIconHover() {
        return this.iconHover;
    }

    public void setIconHover(String iconHover) {
        this.iconHover = iconHover;
    }

    public String getIconActive() {
        return this.iconActive;
    }

    public void setIconActive(String iconActive) {
        this.iconActive = iconActive;
    }

    public Boolean getExclusive() {
        return this.exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public String getShowIcons() {
        return this.showIcons;
    }

    public void setShowIcons(String showIcons) {
        this.showIcons = showIcons;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getCodeSyntax() {
        return this.codeSyntax;
    }

    public void setCodeSyntax(String codeSyntax) {
        this.codeSyntax = codeSyntax;
    }

    public String getCodeTheme() {
        return this.codeTheme;
    }

    public void setCodeTheme(String codeTheme) {
        this.codeTheme = codeTheme;
    }

    public Boolean getLite() {
        return this.lite;
    }

    public void setLite(Boolean lite) {
        this.lite = lite;
    }

    public Boolean getLabels() {
        return this.labels;
    }

    public void setLabels(Boolean labels) {
        this.labels = labels;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getSearchLimit() {
        return this.searchLimit;
    }

    public void setSearchLimit(Integer searchLimit) {
        this.searchLimit = searchLimit;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getJsonModel() {
        return this.jsonModel;
    }

    public void setJsonModel(String jsonModel) {
        this.jsonModel = jsonModel;
    }

    public List<Hilite> getHilites() {
        return this.hilites;
    }

    public void setHilites(List<Hilite> hilites) {
        this.hilites = hilites;
    }

    public List<AbstractView> getViews() {
        if (this.views != null && this.getTarget() != null) {
            for (AbstractView abstractView : this.views) {
                abstractView.setModel(this.getTarget());
            }
        }
        return this.views;
    }

    public void setViews(List<AbstractView> views) {
        this.views = views;
    }

    public String getMinSize() {
        return this.minSize;
    }

    public void setMinSize(String minSize) {
        this.minSize = minSize;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(String maxSize) {
        this.maxSize = maxSize;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(String fgColor) {
        this.fgColor = fgColor;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public String getEditWindow() {
        return this.editWindow;
    }

    public void setEditWindow(String editWindow) {
        this.editWindow = editWindow;
    }

    public String getFormView() {
        return this.formView;
    }

    public void setFormView(String formView) {
        this.formView = formView;
    }

    public String getGridView() {
        return this.gridView;
    }

    public void setGridView(String gridView) {
        this.gridView = gridView;
    }

    public String getSummaryView() {
        return this.summaryView;
    }

    public void setSummaryView(String summaryView) {
        this.summaryView = summaryView;
    }

    private String getTargetModel() {
        Mapper mapper = null;
        try {
            mapper = Mapper.of(Class.forName(this.getModel()));
            return mapper.getProperty(this.getName()).getTarget().getName();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @XmlTransient
    @JsonProperty
    public Collection<?> getJsonFields() {
        Map<String, Object> fields = StringUtils.isBlank((CharSequence)this.jsonModel) ? MetaStore.findJsonFields(this.getModel(), this.getName()) : MetaStore.findJsonFields(this.jsonModel);
        return fields == null ? null : fields.values();
    }
}

