/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import com.axelor.common.StringUtils;
import com.axelor.db.mapper.Mapper;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.views.AbstractPanel;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.Button;
import com.axelor.meta.schema.views.PanelField;
import com.axelor.meta.schema.views.SimpleWidget;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlType
@JsonTypeName(value="panel-related")
public class PanelRelated
extends AbstractPanel {
    @XmlAttribute(name="field")
    private String name;
    @XmlAttribute(name="type")
    private String serverType;
    @XmlAttribute(name="form-view")
    private String formView;
    @XmlAttribute(name="grid-view")
    private String gridView;
    @XmlAttribute(name="x-search-limit")
    private Integer searchLimit;
    @XmlAttribute(name="x-row-height")
    private Integer rowHeight;
    @XmlAttribute
    private Boolean editable;
    @XmlAttribute
    private Boolean required;
    @XmlAttribute
    private String requiredIf;
    @XmlAttribute
    private String validIf;
    @XmlAttribute
    private String orderBy;
    @XmlAttribute
    private String groupBy;
    @XmlAttribute
    private String domain;
    @XmlAttribute
    private String target;
    @XmlAttribute(name="target-name")
    private String targetName;
    @XmlAttribute
    private String onNew;
    @XmlAttribute
    private String onChange;
    @XmlAttribute
    private String onSelect;
    @XmlAttribute
    private String canSelect;
    @XmlAttribute
    private String canNew;
    @XmlAttribute
    private String canView;
    @XmlAttribute
    private String canEdit;
    @XmlAttribute
    private String canRemove;
    @XmlAttribute
    private Boolean canMove;
    @XmlAttribute(name="edit-window")
    private String editWindow;
    @XmlElements(value={@XmlElement(name="field", type=PanelField.class), @XmlElement(name="button", type=Button.class)})
    private List<AbstractWidget> items;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getServerType() {
        if (this.serverType == null) {
            try {
                Mapper mapper = Mapper.of(Class.forName(this.getModel()));
                this.serverType = mapper.getProperty(this.getName()).getType().name();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getFormView() {
        return this.formView;
    }

    public void setFormView(String formView) {
        this.formView = formView;
    }

    public String getGridView() {
        return this.gridView;
    }

    public void setGridView(String gridView) {
        this.gridView = gridView;
    }

    public Integer getSearchLimit() {
        return this.searchLimit;
    }

    public void setSearchLimit(Integer searchLimit) {
        this.searchLimit = searchLimit;
    }

    public Integer getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(Integer rowHeight) {
        this.rowHeight = rowHeight;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getRequiredIf() {
        return this.requiredIf;
    }

    public void setRequiredIf(String requiredIf) {
        this.requiredIf = requiredIf;
    }

    public String getValidIf() {
        return this.validIf;
    }

    public void setValidIf(String validIf) {
        this.validIf = validIf;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getOnNew() {
        return this.onNew;
    }

    public void setOnNew(String onNew) {
        this.onNew = onNew;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public String getOnSelect() {
        return this.onSelect;
    }

    public void setOnSelect(String onSelect) {
        this.onSelect = onSelect;
    }

    public String getCanNew() {
        return this.canNew;
    }

    public void setCanNew(String canNew) {
        this.canNew = canNew;
    }

    public String getCanView() {
        return this.canView;
    }

    public void setCanView(String canView) {
        this.canView = canView;
    }

    public String getCanEdit() {
        return this.canEdit;
    }

    public void setCanEdit(String canEdit) {
        this.canEdit = canEdit;
    }

    public String getCanRemove() {
        return this.canRemove;
    }

    public void setCanRemove(String canRemove) {
        this.canRemove = canRemove;
    }

    public String getCanSelect() {
        return this.canSelect;
    }

    public void setCanSelect(String canSelect) {
        this.canSelect = canSelect;
    }

    public Boolean getCanMove() {
        return this.canMove;
    }

    public void setCanMove(Boolean canMove) {
        this.canMove = canMove;
    }

    public String getEditWindow() {
        return this.editWindow;
    }

    public void setEditWindow(String editWindow) {
        this.editWindow = editWindow;
    }

    public List<AbstractWidget> getItems() {
        return this.process(this.items);
    }

    public void setItems(List<AbstractWidget> items) {
        this.items = items;
    }

    public Map<String, Object> getPerms() {
        try {
            return MetaStore.getPermissions(Class.forName(this.getTarget()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @JsonGetter(value="fields")
    public List<Object> getTargetFields() {
        Class<?> target;
        if (this.getItems() == null || this.getItems().isEmpty()) {
            return null;
        }
        try {
            target = Class.forName(this.getTarget());
        }
        catch (Exception e) {
            try {
                target = Mapper.of(Class.forName(this.getModel())).getProperty(this.getName()).getTarget();
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (target == null) {
            return null;
        }
        ArrayList<Object> targetFields = new ArrayList<Object>();
        List<String> names = this.getItems().stream().filter(x -> x instanceof SimpleWidget).map(x -> ((SimpleWidget)x).getName()).filter(n -> !StringUtils.isBlank((CharSequence)n)).collect(Collectors.toList());
        Map<String, Object> fields = MetaStore.findFields(target, names);
        targetFields.addAll((Collection)fields.get("fields"));
        return targetFields;
    }
}

