/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Node;

@XmlType
@XmlEnum
public enum Position {
    AFTER(Node::getParentNode, Node::getNextSibling),
    BEFORE(Node::getParentNode, Function.identity()),
    INSIDE_LAST(Function.identity(), node -> null),
    INSIDE_FIRST(Function.identity(), Node::getFirstChild);

    private final Function<Node, Node> parentNodeFunc;
    private final Function<Node, Node> refChildNodeFunc;
    private static final Map<String, Position> POSITION_TYPES;

    private Position(Function<Node, Node> parentNodeFunc, Function<Node, Node> refChildNodeFunc) {
        this.parentNodeFunc = parentNodeFunc;
        this.refChildNodeFunc = refChildNodeFunc;
    }

    public void insert(Node node, Node newChild) {
        this.parentNodeFunc.apply(node).insertBefore(newChild, this.refChildNodeFunc.apply(node));
    }

    public static Position get(String name) {
        return POSITION_TYPES.getOrDefault(name, AFTER);
    }

    static {
        POSITION_TYPES = Arrays.stream(Position.class.getFields()).collect(Collectors.toMap(field -> field.getAnnotation(XmlEnumValue.class).value(), field -> {
            try {
                return (Position)((Object)((Object)field.get(Position.class)));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }));
    }
}

