/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.QueryBinder;
import com.axelor.db.internal.DBHelper;
import com.axelor.db.mapper.Adapter;
import com.axelor.db.mapper.Mapper;
import com.axelor.i18n.I18n;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.Field;
import com.axelor.script.CompositeScriptHelper;
import com.axelor.script.ScriptBindings;
import com.axelor.script.ScriptHelper;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.persistence.Query;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

@XmlType
@JsonTypeName(value="search")
public class Search
extends AbstractView {
    @XmlAttribute
    private Integer limit;
    @XmlAttribute(name="search-form")
    private String searchForm;
    @XmlElement(name="field", type=SearchField.class)
    @XmlElementWrapper(name="search-fields")
    private List<SearchField> searchFields;
    @XmlElement(name="field", type=SearchField.class)
    @XmlElementWrapper(name="result-fields")
    private List<SearchField> resultFields;
    @XmlElement(name="select")
    private List<SearchSelect> selects;

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String getSearchForm() {
        return this.searchForm;
    }

    public void setSearchForm(String searchForm) {
        this.searchForm = searchForm;
    }

    public List<SearchField> getSearchFields() {
        return this.searchFields;
    }

    public void setSearchFields(List<SearchField> searchFields) {
        this.searchFields = searchFields;
    }

    public SearchField getSearchField(String name) {
        for (SearchField field : this.searchFields) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public List<SearchField> getResultFields() {
        return this.resultFields;
    }

    public void setResultFields(List<SearchField> resultFields) {
        this.resultFields = resultFields;
    }

    public List<SearchSelect> getSelects() {
        return this.selects;
    }

    public void setSelects(List<SearchSelect> selects) {
        this.selects = selects;
    }

    public ScriptHelper scriptHandler(Map<String, Object> variables) {
        HashMap map = Maps.newHashMap(variables);
        for (SearchField field : this.searchFields) {
            map.put(field.getName(), field.validate(variables.get(field.getName())));
        }
        return new CompositeScriptHelper(new ScriptBindings(map));
    }

    @XmlType
    public static class SearchSelectInput {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String field;
        @XmlAttribute
        private String matchStyle;
        @XmlAttribute(name="if")
        private String condition;
        @XmlAttribute(name="expr")
        private String expression;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getMatchStyle() {
            return this.matchStyle;
        }

        public void setMatchStyle(String matchStyle) {
            this.matchStyle = matchStyle;
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }
    }

    @XmlType
    public static class SearchSelectWhere {
        @XmlAttribute
        private String match;
        @XmlAttribute
        private Boolean showArchived;
        @XmlElement(name="input")
        private List<SearchSelectInput> inputs;

        public String getMatch() {
            return this.match;
        }

        public Boolean getShowArchived() {
            return this.showArchived;
        }

        public List<SearchSelectInput> getInputs() {
            return this.inputs;
        }

        private Object getValue(SearchSelectInput input, ScriptHelper handler) {
            Object value = null;
            String[] names = input.getName().split("\\.");
            value = handler.getBindings().get(names[0]);
            if (input.getExpression() != null) {
                return handler.eval(input.getExpression());
            }
            if (value == null || names.length == 1) {
                return value;
            }
            for (int i = 1; i < names.length; ++i) {
                if (value instanceof Map) {
                    value = ((Map)value).get(names[i]);
                    continue;
                }
                if (!(value instanceof Model)) continue;
                Mapper mapper = Mapper.of(value.getClass());
                value = mapper.get(value, names[i]);
            }
            return value;
        }

        Map<String, Object> build(StringBuilder builder, JoinHelper joinHelper, ScriptHelper handler) {
            ArrayList where = Lists.newArrayList();
            HashMap binding = Maps.newHashMap();
            HashMultimap groups = HashMultimap.create();
            boolean filterArchived = this.showArchived != Boolean.TRUE;
            String join = "any".equals(this.match) ? " OR " : " AND ";
            for (SearchSelectInput input : this.inputs) {
                if (!handler.test(input.condition)) continue;
                String name = input.getField();
                String as = input.getName();
                Object value = this.getValue(input, handler);
                if (value == null) continue;
                name = joinHelper.joinName(name);
                String left = "LOWER(" + name + ")";
                String operator = "LIKE";
                if ("contains".equals(input.matchStyle)) {
                    value = "%" + value.toString().toLowerCase() + "%";
                } else if ("startsWith".equals(input.matchStyle)) {
                    value = value.toString().toLowerCase() + "%";
                } else if ("endsWith".equals(input.matchStyle)) {
                    value = "%" + value.toString().toLowerCase();
                } else if ("lessThan".equals(input.matchStyle)) {
                    operator = "<";
                    left = name;
                } else if ("greaterThan".equals(input.matchStyle)) {
                    operator = ">";
                    left = name;
                } else if ("lessOrEqual".equals(input.matchStyle)) {
                    operator = "<=";
                    left = name;
                } else if ("greaterOrEqual".equals(input.matchStyle)) {
                    operator = ">=";
                    left = name;
                } else if ("notEquals".equals(input.matchStyle)) {
                    operator = "!=";
                    left = name;
                } else {
                    operator = "=";
                    left = name;
                }
                if ("archived".equals(input.getField())) {
                    boolean bl = filterArchived = value != Boolean.TRUE;
                    if (filterArchived) continue;
                }
                String filter = null;
                String first = as.split("\\.")[0];
                as = as.replace('.', '_');
                filter = "LIKE".equals(operator) && DBHelper.isUnaccentEnabled() ? String.format("unaccent(%s) %s unaccent(:%s)", left, operator, as) : String.format("%s %s :%s", left, operator, as);
                binding.put(as, value);
                groups.put((Object)first, (Object)filter);
            }
            for (Collection items : groups.asMap().values()) {
                String clause = Joiner.on((String)" OR ").join((Iterable)items);
                if (items.size() > 1) {
                    clause = "(" + clause + ")";
                }
                where.add(clause);
            }
            if (where.size() > 0) {
                builder.append(" ").append(joinHelper.toString());
            }
            builder.append(" WHERE ");
            if (filterArchived) {
                builder.append("(self.archived is null OR self.archived = false)");
            }
            if (where.size() > 0) {
                if (filterArchived) {
                    builder.append(" AND (");
                }
                Joiner.on((String)join).appendTo(builder, (Iterable)where);
                if (filterArchived) {
                    builder.append(")");
                }
                return binding;
            }
            return null;
        }
    }

    @XmlType
    public static class SearchSelectField {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String as;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAs() {
            return this.as;
        }

        public void setAs(String as) {
            this.as = as;
        }
    }

    @XmlType
    public static class SearchSelect {
        @XmlAttribute
        private String model;
        @XmlAttribute
        private String title;
        @XmlAttribute(name="view-title")
        private String viewTitle;
        @XmlAttribute
        private Boolean selected;
        @JsonIgnore
        @XmlAttribute
        private String orderBy;
        @JsonIgnore
        @XmlAttribute(name="if")
        private String condition;
        @XmlAttribute(name="form-view")
        private String formView;
        @XmlAttribute(name="grid-view")
        private String gridView;
        @JsonIgnore
        @XmlElement(name="field")
        private List<SearchSelectField> fields;
        @JsonIgnore
        @XmlElement
        private SearchSelectWhere where;
        private transient String queryString;

        public String getQueryString() {
            return this.queryString;
        }

        public String getModel() {
            return this.model;
        }

        @JsonGetter(value="title")
        public String getLocalizedTitle() {
            if (this.title == null && this.model != null) {
                return this.model.substring(this.model.lastIndexOf(46) + 1);
            }
            return I18n.get(this.title);
        }

        @JsonIgnore
        public String getTitle() {
            return this.title;
        }

        public String getViewTitle() {
            return this.viewTitle;
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public String getCondition() {
            return this.condition;
        }

        public String getFormView() {
            return this.formView;
        }

        public String getGridView() {
            return this.gridView;
        }

        public List<SearchSelectField> getFields() {
            return this.fields;
        }

        public SearchSelectWhere getWhere() {
            return this.where;
        }

        public Query toQuery(Search search, ScriptHelper scriptHelper) throws ClassNotFoundException {
            if (!scriptHelper.test(this.condition)) {
                return null;
            }
            Class<?> klass = Class.forName(this.getModel());
            ArrayList selection = Lists.newArrayList((Object[])new String[]{"self.id AS id", "self.version AS version"});
            JoinHelper joinHelper = new JoinHelper();
            for (SearchSelectField field : this.fields) {
                String name = field.getName();
                String as = field.getAs();
                name = joinHelper.joinName(name);
                selection.add(String.format("%s AS %s", name, as));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT new map(");
            Joiner.on((String)", ").appendTo(builder, (Iterable)selection);
            builder.append(")");
            builder.append(" FROM ").append(klass.getSimpleName()).append(" self");
            Map<String, Object> binding = this.where.build(builder, joinHelper, scriptHelper);
            if (binding == null || binding.size() == 0) {
                return null;
            }
            ArrayList orders = Lists.newArrayList();
            if (this.orderBy != null) {
                for (String spec : Splitter.on((Pattern)Pattern.compile(",\\s*")).split((CharSequence)this.orderBy)) {
                    if (spec.startsWith("-")) {
                        orders.add(spec.substring(1) + " DESC");
                        continue;
                    }
                    orders.add(spec);
                }
            }
            if (orders.size() > 0) {
                builder.append(" ORDER BY ");
                Joiner.on((String)", ").appendTo(builder, (Iterable)orders);
            }
            this.queryString = builder.toString();
            Query query = JPA.em().createQuery(this.queryString);
            QueryBinder.of(query).bind(binding, new Object[0]);
            return query;
        }
    }

    static class JoinHelper {
        private Map<String, String> joins = Maps.newLinkedHashMap();

        JoinHelper() {
        }

        public String joinName(String name) {
            String[] path = name.split("\\.");
            String prefix = null;
            String variable = name;
            if (path.length > 1) {
                variable = path[path.length - 1];
                String joinOn = null;
                for (int i = 0; i < path.length - 1; ++i) {
                    String item = path[i].replace("[]", "");
                    if (prefix == null) {
                        joinOn = "self." + item;
                        prefix = "_" + item;
                    } else {
                        joinOn = prefix + "." + item;
                        prefix = prefix + "_" + item;
                    }
                    if (this.joins.containsKey(joinOn)) continue;
                    this.joins.put(joinOn, prefix);
                }
            }
            if (prefix == null) {
                prefix = "self";
            }
            return prefix + "." + variable;
        }

        public String toString() {
            if (this.joins.size() == 0) {
                return "";
            }
            ArrayList joinItems = Lists.newArrayList();
            for (String key : this.joins.keySet()) {
                String val = this.joins.get(key);
                joinItems.add("LEFT JOIN " + key + " " + val);
            }
            return Joiner.on((String)" ").join((Iterable)joinItems);
        }
    }

    @XmlType
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class SearchField
    extends Field {
        @XmlAttribute
        private Boolean multiple;
        private static final Map<String, Class<?>> TYPES = new ImmutableMap.Builder().put((Object)"string", String.class).put((Object)"integer", Integer.class).put((Object)"decimal", BigDecimal.class).put((Object)"date", LocalDate.class).put((Object)"datetime", LocalDateTime.class).put((Object)"boolean", Boolean.class).build();

        public Boolean getMultiple() {
            return this.multiple;
        }

        @Override
        @JsonGetter(value="type")
        public String getServerType() {
            return super.getServerType();
        }

        public static Map<String, Class<?>> getTypes() {
            return TYPES;
        }

        public Object validate(Object input) {
            try {
                Class<?> klass = TYPES.get(this.getServerType());
                if ("reference".equals(this.getServerType())) {
                    klass = Class.forName(this.getTarget());
                    if (input != null) {
                        return JPA.em().find(klass, (Object)Long.valueOf(((Map)input).get("id").toString()));
                    }
                }
                if (klass != null) {
                    return Adapter.adapt(input, klass, klass, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return input;
        }
    }
}

