/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import com.axelor.i18n.I18n;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.Field;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
@JsonTypeName(value="search-filters")
public class SearchFilters
extends AbstractView {
    @XmlElement(name="field", type=Field.class)
    private List<AbstractWidget> items;
    @XmlElement(name="filter")
    private List<SearchFilter> filters;

    public List<AbstractWidget> getItems() {
        return this.items;
    }

    public List<SearchFilter> getFilters() {
        if (this.filters != null) {
            for (SearchFilter searchFilter : this.filters) {
                searchFilter.setModel(super.getModel());
            }
        }
        return this.filters;
    }

    @XmlType
    public static class SearchContext {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    @XmlType
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class SearchFilter {
        @XmlAttribute
        private String title;
        @XmlElement
        private String domain;
        @JsonIgnore
        private String model;
        @JsonIgnore
        @XmlElement(name="context")
        private List<SearchContext> contexts;

        @JsonGetter(value="title")
        public String getLocalizedTitle() {
            return I18n.get(this.title);
        }

        @JsonIgnore
        public String getTitle() {
            return this.title;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public Map<String, Object> getContext() {
            if (this.contexts == null || this.contexts.isEmpty()) {
                return null;
            }
            HashMap context = Maps.newHashMap();
            for (SearchContext ctx : this.contexts) {
                context.put(ctx.getName(), ctx.getValue());
            }
            return context;
        }
    }
}

