/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.Button;
import com.axelor.meta.schema.views.Field;
import com.axelor.meta.schema.views.Search;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlType
@JsonTypeName(value="tree")
public class TreeView
extends AbstractView {
    @XmlAttribute
    private Boolean showHeader;
    @XmlElement(name="column")
    private List<TreeColumn> columns;
    @XmlElement(name="node")
    private List<Node> nodes;

    public Boolean getShowHeader() {
        return this.showHeader;
    }

    public List<TreeColumn> getColumns() {
        return this.columns;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    @XmlType
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class NodeField
    extends Field {
        @XmlAttribute
        private String as;

        public String getAs() {
            return this.as;
        }

        @Override
        public String getSelection() {
            Class<?> klass;
            String selection = super.getSelection();
            if (selection != null) {
                return selection;
            }
            try {
                klass = Class.forName(this.getModel());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            Iterator iter = Splitter.on((String)".").split((CharSequence)this.getName()).iterator();
            Mapper current = Mapper.of(klass);
            Property property = current.getProperty((String)iter.next());
            while (iter.hasNext()) {
                if (property == null || property.getTarget() == null) {
                    return null;
                }
                current = Mapper.of(property.getTarget());
                property = current.getProperty((String)iter.next());
            }
            return property == null ? null : property.getSelection();
        }
    }

    @XmlType
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Node {
        @XmlAttribute
        private String model;
        @XmlAttribute
        private String parent;
        @XmlAttribute
        private String onClick;
        @XmlAttribute
        private Boolean draggable;
        @XmlAttribute
        private String domain;
        @XmlAttribute
        private String orderBy;
        @XmlElements(value={@XmlElement(name="field", type=NodeField.class), @XmlElement(name="button", type=Button.class)})
        private List<AbstractWidget> items;

        public String getModel() {
            return this.model;
        }

        public String getParent() {
            return this.parent;
        }

        public String getOnClick() {
            return this.onClick;
        }

        public Boolean getDraggable() {
            return this.draggable;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public List<AbstractWidget> getItems() {
            if (this.items != null) {
                for (AbstractWidget item : this.items) {
                    item.setModel(this.model);
                }
            }
            return this.items;
        }
    }

    @XmlType
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class TreeColumn
    extends Search.SearchField {
    }
}

