/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.service;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Query;
import com.axelor.i18n.I18n;
import com.axelor.meta.db.MetaFilter;
import com.axelor.meta.db.repo.MetaFilterRepository;
import com.google.common.base.Objects;
import com.google.inject.persist.Transactional;
import java.util.List;
import javax.inject.Inject;
import org.apache.shiro.authz.AuthorizationException;

public class MetaFilterService {
    @Inject
    private MetaFilterRepository filters;

    @Transactional
    public MetaFilter saveFilter(MetaFilter ctx) {
        User user = AuthUtils.getUser();
        String query = "self.name = ?1 AND self.filterView = ?2 AND (self.user.code = ?3 OR self.shared = true)";
        MetaFilter filter = (MetaFilter)this.filters.all().filter(query, ctx.getName(), ctx.getFilterView(), user.getCode()).fetchOne();
        if (filter == null) {
            filter = new MetaFilter();
            filter.setName(ctx.getName());
            filter.setUser(user);
            filter.setFilterView(ctx.getFilterView());
        }
        filter.setTitle(ctx.getTitle());
        filter.setFilters(ctx.getFilters());
        filter.setFilterCustom(ctx.getFilterCustom());
        if (Objects.equal((Object)filter.getUser(), (Object)user)) {
            filter.setShared(ctx.getShared());
        }
        return this.filters.save(filter);
    }

    @Transactional
    public MetaFilter removeFilter(MetaFilter ctx) {
        User user = AuthUtils.getUser();
        String query = "self.name = ?1 AND self.filterView = ?2 AND (self.user.code = ?3 OR self.shared = true)";
        MetaFilter filter = (MetaFilter)this.filters.all().filter(query, ctx.getName(), ctx.getFilterView(), user.getCode()).fetchOne();
        if (!Objects.equal((Object)filter.getUser(), (Object)user)) {
            throw new AuthorizationException(I18n.get("You are not allowed to remove this filter"));
        }
        this.filters.remove(filter);
        return ctx;
    }

    public List<MetaFilter> getFilters(String filterView) {
        User user = AuthUtils.getUser();
        String query = "self.filterView = ?1 AND (self.user.code = ?2 OR self.shared = true)";
        return Query.of(MetaFilter.class).filter(query, filterView, user.getCode()).order("id").fetch();
    }
}

