/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.quartz;

import com.axelor.app.AppSettings;
import com.axelor.db.JPA;
import com.axelor.i18n.I18n;
import com.axelor.meta.CallMethod;
import com.axelor.meta.db.MetaSchedule;
import com.axelor.meta.db.MetaScheduleParam;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JobRunner {
    private static Logger log = LoggerFactory.getLogger(JobRunner.class);
    private static final String CONFIG_QUARTZ_ENABLE = "quartz.enable";
    private static final String META_SCHEDULE_QUERY = "SELECT DISTINCT self FROM MetaSchedule self LEFT JOIN FETCH self.params";
    private Scheduler scheduler;
    private int total;

    @Inject
    public JobRunner(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @CallMethod
    public boolean isEnabled() {
        return AppSettings.get().getBoolean(CONFIG_QUARTZ_ENABLE, false);
    }

    private void configure() {
        if (this.total > 0) {
            return;
        }
        this.total = 0;
        log.info("Configuring scheduled jobs...");
        JPA.em().createQuery(META_SCHEDULE_QUERY, MetaSchedule.class).getResultList().stream().forEach(this::configure);
        log.info("Configured total jobs: {}", (Object)this.total);
    }

    private void configure(MetaSchedule meta) {
        CronScheduleBuilder cronSchedule;
        Class<?> klass;
        if (meta == null || meta.getActive() != Boolean.TRUE) {
            return;
        }
        String name = meta.getName();
        String cron = meta.getCron();
        String jobClass = meta.getJob();
        log.info("Configuring job: {}, {}", (Object)name, (Object)cron);
        try {
            klass = Class.forName(jobClass);
        }
        catch (ClassNotFoundException e1) {
            log.error("No such job class found: {}", (Object)jobClass);
            return;
        }
        if (klass == null || !Job.class.isAssignableFrom(klass)) {
            log.error("Invalid job class: {}", (Object)jobClass);
            return;
        }
        try {
            cronSchedule = CronScheduleBuilder.cronSchedule((String)cron);
        }
        catch (Exception e) {
            log.error("Invalid cron string: {}", (Object)cron);
            return;
        }
        JobDataMap data = new JobDataMap();
        if (meta.getParams() != null) {
            for (MetaScheduleParam param : meta.getParams()) {
                data.put(param.getName(), param.getValue());
            }
        }
        JobDetail detail = JobBuilder.newJob(klass).withIdentity(name).withDescription(meta.getDescription()).usingJobData(data).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name).withDescription(meta.getDescription()).withSchedule((ScheduleBuilder)cronSchedule).build();
        try {
            this.scheduler.scheduleJob(detail, trigger);
        }
        catch (SchedulerException e) {
            log.error("Unable to configure scheduled job: {}", (Object)name, (Object)e);
        }
        ++this.total;
    }

    public void update(MetaSchedule meta) throws SchedulerException {
        if (!this.isEnabled()) {
            throw new IllegalStateException(I18n.get("The scheduler service is disabled."));
        }
        Preconditions.checkNotNull((Object)meta);
        JobKey jobKey = new JobKey(meta.getName());
        if (this.scheduler.checkExists(jobKey)) {
            log.info("Deleting job: {}", (Object)meta.getName());
            this.scheduler.deleteJob(jobKey);
            --this.total;
        }
        if (meta.getActive() != Boolean.TRUE) {
            return;
        }
        this.configure(meta);
    }

    public void start() {
        if (!this.isEnabled()) {
            throw new IllegalStateException(I18n.get("The scheduler service is disabled."));
        }
        this.configure();
        log.info("Starting scheduler...");
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            log.error("Unable to start the scheduler...");
            log.trace("Scheduler error: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        log.info("Job scheduler is running...");
    }

    public void stop() {
        log.info("Stopping scheduler...");
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            log.error("Unable to stop the scheduler...");
            log.trace("Scheduler error: {}", (Object)e.getMessage(), (Object)e);
        }
        log.info("The job scheduler stopped.");
    }

    public void restart() {
        try {
            this.scheduler.clear();
        }
        catch (SchedulerException e) {
            log.error("Unable to clear existing jobs...");
            log.trace("Scheduler error: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        this.total = 0;
        this.start();
    }
}

