/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.quartz;

import com.axelor.app.AppSettings;
import com.axelor.quartz.GuiceJobFactory;
import com.axelor.quartz.GuiceSchedulerFactory;
import com.axelor.quartz.JobCleaner;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;

@Singleton
class SchedulerProvider
implements Provider<Scheduler> {
    private static final String DEFAULT_THREAD_COUNT = "3";
    private static final String THREAD_COUNT_GET = "quartz.threadCount";
    private static final String THREAD_COUNT_SET = "org.quartz.threadPool.threadCount";
    @Inject
    private GuiceJobFactory jobFactory;
    @Inject
    private JobCleaner jobCleaner;

    SchedulerProvider() {
    }

    public Scheduler get() {
        Scheduler scheduler;
        Properties cfg = new Properties();
        cfg.put(THREAD_COUNT_SET, AppSettings.get().get(THREAD_COUNT_GET, DEFAULT_THREAD_COUNT));
        try {
            GuiceSchedulerFactory schedulerFactory = new GuiceSchedulerFactory(cfg);
            scheduler = schedulerFactory.getScheduler();
            scheduler.setJobFactory((JobFactory)this.jobFactory);
            scheduler.getListenerManager().addJobListener((JobListener)this.jobCleaner);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        return scheduler;
    }
}

