/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.rpc.Context;
import com.axelor.rpc.ContextEntity;
import com.axelor.rpc.ContextHandlerFactory;
import com.axelor.rpc.JsonContext;
import com.axelor.rpc.Resource;
import com.google.common.collect.Collections2;
import com.google.common.primitives.Longs;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHandler<T> {
    private static final String FIELD_ID = "id";
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_SELECTED = "selected";
    private static final Logger log = LoggerFactory.getLogger(ContextHandler.class);
    private final PropertyChangeSupport changeListeners;
    private final Map<String, Object> values;
    private final Set<String> validated;
    private final Class<T> beanClass;
    private final Mapper beanMapper;
    private T managedEntity;
    private T unmanagedEntity;
    private T proxy;
    private JsonContext jsonContext;
    private boolean searched;

    ContextHandler(Class<T> beanClass, Map<String, Object> values) {
        this.values = Objects.requireNonNull(values);
        this.validated = new HashSet<String>();
        this.beanClass = Objects.requireNonNull(beanClass);
        this.beanMapper = Mapper.of(beanClass);
        this.changeListeners = new PropertyChangeSupport(this);
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeListeners.addPropertyChangeListener(listener);
    }

    private Long findId(Map<String, Object> values) {
        try {
            return Long.parseLong(values.get(FIELD_ID).toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    private T getManagedEntity() {
        if (this.searched) {
            return this.managedEntity;
        }
        Long id = this.findId(this.values);
        if (id != null) {
            this.managedEntity = JPA.em().find(this.beanClass, (Object)id);
        }
        this.searched = true;
        return this.managedEntity;
    }

    private T getUnmanagedEntity() {
        if (this.unmanagedEntity == null) {
            this.unmanagedEntity = Mapper.toBean(this.beanClass, null);
        }
        return this.unmanagedEntity;
    }

    public T getProxy() {
        return this.proxy;
    }

    void setProxy(T proxy) {
        this.proxy = proxy;
    }

    private JsonContext getJsonContext() {
        if (this.jsonContext == null) {
            this.jsonContext = this.createJsonContext();
        }
        return this.jsonContext;
    }

    private JsonContext createJsonContext() {
        if (MetaJsonRecord.class.isAssignableFrom(this.beanClass)) {
            MetaJsonRecord rec = (MetaJsonRecord)this.proxy;
            return new JsonContext(rec);
        }
        Property p = this.beanMapper.getProperty("attrs");
        Context c = new Context(this.beanClass);
        return new JsonContext(c, p, (String)p.get(this.proxy));
    }

    private Object createOrFind(Property property, Object item) {
        if (item == null || item instanceof Model) {
            return item;
        }
        if (item instanceof Map) {
            Map map = (Map)item;
            Long id = this.findId(map);
            if (id == null || id <= 0L || map.containsKey(FIELD_VERSION)) {
                return ContextHandlerFactory.newHandler(property.getTarget(), map).getProxy();
            }
            Object bean = JPA.em().find(property.getTarget(), (Object)id);
            if (map.containsKey(FIELD_SELECTED)) {
                Mapper.of(property.getTarget()).set(bean, FIELD_SELECTED, map.get(FIELD_SELECTED));
            }
            return bean;
        }
        if (item instanceof Number) {
            return JPA.em().find(property.getTarget(), item);
        }
        throw new IllegalArgumentException("Invalid collection item for field: " + property.getName());
    }

    Object validate(Property property, Object value) {
        if (property == null) {
            return value;
        }
        if (property.isCollection() && value instanceof Collection) {
            value = ((Collection)value).stream().map(item -> this.createOrFind(property, item)).collect(Collectors.toList());
        } else if (property.isReference()) {
            value = this.createOrFind(property, value);
        }
        return value;
    }

    private void validate(Property property) {
        if (property == null || this.validated.contains(property.getName()) || !this.values.containsKey(property.getName())) {
            return;
        }
        Object value = this.validate(property, this.values.get(property.getName()));
        T bean = this.getUnmanagedEntity();
        Mapper mapper = this.beanMapper;
        if (mapper.getSetter(property.getName()) == null && bean instanceof AuditableModel) {
            mapper = Mapper.of(AuditableModel.class);
        }
        mapper.set(bean, property.getName(), value);
        this.validated.add(property.getName());
    }

    private Object interceptComputeAccess(Callable<?> superCall, Method method, Object[] args) throws Exception {
        Set<String> depends;
        Property computed = this.beanMapper.getProperty(method);
        if (computed == null || (depends = this.beanMapper.getComputeDependencies(computed)) == null || depends.isEmpty()) {
            return superCall.call();
        }
        for (String name : depends) {
            Property property;
            if (this.validated.contains(name) || (property = this.beanMapper.getProperty(name)) == null) continue;
            if (this.values.containsKey(name)) {
                this.validate(property);
                continue;
            }
            T managed = this.getManagedEntity();
            if (managed == null) continue;
            this.beanMapper.set(this.getUnmanagedEntity(), name, property.get(managed));
        }
        method.setAccessible(true);
        return method.invoke(this.getUnmanagedEntity(), args);
    }

    public Object interceptJsonAccess(Method method, Object[] args) throws Exception {
        String name = (String)args[0];
        if ("class".equals(name)) {
            return method.invoke(this.proxy, args);
        }
        if ("get".equals(method.getName()) || "put".equals(method.getName())) {
            Object[] objectArray;
            Method accessor;
            Method method2 = accessor = args.length == 1 ? this.beanMapper.getGetter(name) : this.beanMapper.getSetter(name);
            if (args.length == 1) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = args[1];
            }
            Object[] params = objectArray;
            if (accessor != null) {
                return accessor.invoke(this.proxy, params);
            }
            JsonContext ctx = this.getJsonContext();
            if (args.length == 1) {
                if (ctx.containsKey(name) || ctx.hasField(name)) {
                    return ctx.get(name);
                }
                if (name.startsWith("_") || name.startsWith("$")) {
                    return null;
                }
                log.warn("No such field: {}.{}", (Object)this.beanClass.getName(), (Object)name);
                return null;
            }
            return ctx.put(name, args[1]);
        }
        throw new UnsupportedOperationException("cannot call '" + method + "' on proxy object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RuntimeType
    public Object intercept(@SuperCall Callable<?> superCall, @Origin Method method, @AllArguments Object[] args) throws Throwable {
        Object oldValue;
        if (superCall == null && method.getDeclaringClass() == Map.class) {
            return this.interceptJsonAccess(method, args);
        }
        if (Modifier.isProtected(method.getModifiers())) {
            return this.interceptComputeAccess(superCall, method, args);
        }
        Property property = this.beanMapper.getProperty(method);
        if (property == null || property.isVirtual()) {
            return superCall.call();
        }
        String fieldName = property.getName();
        T unmanaged = this.getUnmanagedEntity();
        Object object = oldValue = args.length == 1 ? this.values.put(fieldName, args[0]) : null;
        if (args.length == 1 || this.values.containsKey(fieldName) || property.isTransient()) {
            this.validate(property);
            try {
                Object object2 = method.invoke(unmanaged, args);
                return object2;
            }
            finally {
                if (args.length == 1 && this.changeListeners.hasListeners(fieldName)) {
                    this.changeListeners.firePropertyChange(fieldName, oldValue, this.values.get(fieldName));
                }
            }
        }
        T managed = this.getManagedEntity();
        if (managed == null) {
            return method.invoke(unmanaged, args);
        }
        return method.invoke(managed, args);
    }

    @RuntimeType
    public Map<String, Object> getContextMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Object bean = this.getContextEntity();
        Function<Object, Object> transform = item -> {
            if (item instanceof ContextEntity) {
                return ((ContextEntity)item).getContextMap();
            }
            if (item instanceof Model) {
                Model m = (Model)item;
                return m.getId() == null ? Resource.toMap(m, new String[0]) : Resource.toMapCompact(m);
            }
            return item;
        };
        Arrays.stream(this.beanMapper.getProperties()).map(Property::getName).filter(this.validated::contains).forEach(name -> {
            Object value = this.beanMapper.get(bean, (String)name);
            value = value instanceof Collection ? Collections2.transform((Collection)((Collection)value), transform::apply) : transform.apply(value);
            data.put((String)name, value);
        });
        return data;
    }

    @RuntimeType
    public Long getContextId() {
        return Longs.tryParse((String)this.values.getOrDefault(FIELD_ID, "").toString());
    }

    @RuntimeType
    public Object getContextEntity() {
        T bean = this.getUnmanagedEntity();
        T managed = this.getManagedEntity();
        Arrays.stream(this.beanMapper.getProperties()).forEach(this::validate);
        if (managed == null) {
            return bean;
        }
        Arrays.stream(this.beanMapper.getProperties()).filter(Property::isVirtual).flatMap(p -> this.beanMapper.getComputeDependencies((Property)p).stream()).filter(n -> !this.validated.contains(n)).distinct().forEach(n -> this.beanMapper.set(bean, (String)n, this.beanMapper.get(managed, (String)n)));
        if (bean instanceof Model && !this.values.containsKey(FIELD_VERSION)) {
            ((Model)bean).setVersion(((Model)managed).getVersion());
        }
        return bean;
    }
}

