/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.rpc.ContextEntity;
import com.axelor.rpc.ContextHandler;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.persistence.Entity;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class ContextHandlerFactory {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final String FIELD_HANDLER = "contextHandler";
    private static final String COMPUTE_METHOD_PREFIX = "compute";
    private static final LoadingCache<Class<?>, Class<?>> PROXY_CACHE = CacheBuilder.newBuilder().weakKeys().maximumSize(500L).build(new CacheLoader<Class<?>, Class<?>>(){

        public Class<?> load(Class<?> key) throws Exception {
            return ContextHandlerFactory.makeProxy(key);
        }
    });

    private ContextHandlerFactory() {
    }

    private static boolean isEntity(Class<?> beanClass) {
        return !Modifier.isAbstract(beanClass.getModifiers()) && beanClass.getAnnotation(Entity.class) != null;
    }

    public static void refresh(Collection<Class<?>> models) {
        PROXY_CACHE.invalidateAll();
        models.parallelStream().filter(ContextHandlerFactory::isEntity).forEach(arg_0 -> PROXY_CACHE.refresh(arg_0));
    }

    private static boolean hasJsonFields(Class<?> beanClass) {
        Property attrs = Mapper.of(beanClass).getProperty("attrs");
        return attrs != null && attrs.isJson();
    }

    private static <T> Class<? extends T> makeProxy(Class<T> beanClass) {
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.subclass(beanClass).method((ElementMatcher)ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.isGetter().or((ElementMatcher)ElementMatchers.isSetter()))).intercept((Implementation)MethodDelegation.toField((String)FIELD_HANDLER)).method((ElementMatcher)ElementMatchers.isProtected().and((ElementMatcher)ElementMatchers.nameStartsWith((String)COMPUTE_METHOD_PREFIX))).intercept((Implementation)MethodDelegation.toField((String)FIELD_HANDLER)).implement(new Type[]{ContextEntity.class}).intercept((Implementation)MethodDelegation.toField((String)FIELD_HANDLER)).defineField(FIELD_HANDLER, ContextHandler.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.TRANSIENT}).implement(new Type[]{HandlerAccessor.class}).intercept((Implementation)FieldAccessor.ofBeanProperty());
        if (ContextHandlerFactory.hasJsonFields(beanClass)) {
            builder = builder.implement(new Type[]{Map.class}).method((ElementMatcher)ElementMatchers.isDeclaredBy(Map.class)).intercept((Implementation)InvocationHandlerAdapter.of((proxy, method, args) -> ((HandlerAccessor)proxy).getContextHandler().intercept(null, method, args)));
        }
        return builder.make().load(beanClass.getClassLoader()).getLoaded();
    }

    public static <T> ContextHandler<T> newHandler(Class<T> beanClass, Map<String, Object> values) {
        ContextHandler<T> handler = new ContextHandler<T>(beanClass, values);
        try {
            Class<T> proxyClass = ((Class)PROXY_CACHE.get(beanClass)).asSubclass(beanClass);
            T proxy = proxyClass.newInstance();
            ((HandlerAccessor)proxy).setContextHandler(handler);
            handler.setProxy(proxy);
            return handler;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface HandlerAccessor {
        public ContextHandler<?> getContextHandler();

        public void setContextHandler(ContextHandler<?> var1);
    }
}

