/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.rpc.Context;
import com.axelor.rpc.Request;
import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.JPQLFilter;
import com.axelor.rpc.filter.Operator;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Criteria {
    private Filter filter;
    private Map<String, Object> domainContext;

    public Criteria(Filter filter) {
        this.filter = filter;
    }

    public <T extends Model> Query<T> createQuery(Class<T> klass) {
        return this.createQuery(klass, null);
    }

    public <T extends Model> Query<T> createQuery(Class<T> klass, Filter and) {
        Query<T> q;
        Query<T> query = q = and == null ? this.filter.build(klass) : Filter.and(this.filter, and, new Filter[0]).build(klass);
        if (this.domainContext != null) {
            Class<Object> domainClass = klass;
            if (this.domainContext.containsKey("_model")) {
                try {
                    domainClass = Class.forName((String)this.domainContext.get("_model"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            Context context = new Context(this.domainContext, domainClass);
            q.bind(context);
        }
        return q;
    }

    public String toString() {
        return this.filter.toString();
    }

    public static Criteria parse(Request request) {
        if (request.getData() == null) {
            return null;
        }
        Map<String, Object> data = request.getData();
        HashMap<String, Object> raw = new HashMap<String, Object>();
        if (data.get("operator") == null) {
            raw.put("operator", "or");
        }
        if (data.get("criteria") != null) {
            raw.putAll(data);
            return Criteria.parse(raw, request.getBeanClass());
        }
        raw.put("operator", "or");
        raw.put("_archived", request.getData().get("_archived"));
        raw.put("_domain", request.getData().get("_domain"));
        raw.put("_domainContext", request.getData().get("_domainContext"));
        ArrayList items = new ArrayList();
        for (String key : request.getData().keySet()) {
            if (!key.matches("^[a-zA-Z].*$")) continue;
            HashMap<String, Object> criterion = new HashMap<String, Object>();
            criterion.put("fieldName", key);
            criterion.put("operator", "like");
            criterion.put("value", request.getData().get(key));
            items.add(criterion);
        }
        raw.put("criteria", items);
        return Criteria.parse(raw, request.getBeanClass());
    }

    public static Criteria parse(Map<String, Object> rawCriteria, Class<?> beanClass) {
        String domain;
        Filter search = Criteria.parseCriterion(rawCriteria, beanClass);
        ArrayList all = Lists.newArrayList();
        HashMap context = Maps.newHashMap();
        List domains = (List)rawCriteria.get("_domains");
        if (domains != null) {
            all.addAll(Criteria.parseDomains(domains, context));
            try {
                if (Operator.get((String)rawCriteria.get("operator")) == Operator.OR && all.size() > 0) {
                    all.clear();
                    all.add(Filter.or(Criteria.parseDomains(domains, context)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((domain = (String)rawCriteria.get("_domain")) != null) {
            all.add(JPQLFilter.forDomain(domain, new Object[0]));
        }
        try {
            context.putAll((Map)rawCriteria.get("_domainContext"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object archived = rawCriteria.get("_archived");
        if (archived != null) {
            archived = "true".equals(archived.toString().toLowerCase());
        }
        if (archived != Boolean.TRUE) {
            all.add(new JPQLFilter("self.archived is null OR self.archived = false", new Object[0]));
        }
        if (!Strings.isNullOrEmpty((String)search.getQuery())) {
            all.add(search);
        }
        Criteria result = new Criteria(Filter.and(all));
        result.domainContext = context;
        return result;
    }

    private static List<Filter> parseDomains(List<?> domains, Map<String, ?> context) {
        ArrayList filters = Lists.newArrayList();
        for (Object item : domains) {
            if (!(item instanceof Map) || !((Map)item).containsKey("domain")) continue;
            Map map = (Map)item;
            filters.add(JPQLFilter.forDomain((String)map.get("domain"), new Object[0]));
            try {
                context.putAll((Map)map.get("context"));
            }
            catch (Exception exception) {}
        }
        return filters;
    }

    private static Filter parseCriterion(Map<String, Object> rawCriteria, Class<?> beanClass) {
        Property property;
        Operator operator = Operator.get((String)rawCriteria.get("operator"));
        if (operator == Operator.AND || operator == Operator.OR || operator == Operator.NOT) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (Object raw : (List)rawCriteria.get("criteria")) {
                filters.add(Criteria.parseCriterion((Map)raw, beanClass));
            }
            if (operator == Operator.AND) {
                return Filter.and(filters);
            }
            if (operator == Operator.OR) {
                return Filter.or(filters);
            }
            if (operator == Operator.NOT) {
                return Filter.not(filters);
            }
        }
        String fieldName = (String)rawCriteria.get("fieldName");
        Object value = rawCriteria.get("value");
        if (value instanceof String && (property = Mapper.of(beanClass).getProperty(fieldName)) != null && property.getTarget() != null) {
            fieldName = fieldName + "." + Mapper.of(property.getTarget()).getNameField().getName();
        }
        if (operator == Operator.BETWEEN) {
            return Filter.between(fieldName, rawCriteria.get("value"), rawCriteria.get("value2"));
        }
        if (operator == Operator.NOT_BETWEEN) {
            return Filter.notBetween(fieldName, rawCriteria.get("value"), rawCriteria.get("value2"));
        }
        if (value instanceof String) {
            value = ((String)value).trim();
        }
        switch (operator) {
            case EQUALS: {
                return Filter.equals(fieldName, value);
            }
            case NOT_EQUAL: {
                return Filter.notEquals(fieldName, value);
            }
            case LESS_THAN: {
                return Filter.lessThan(fieldName, value);
            }
            case GREATER_THAN: {
                return Filter.greaterThan(fieldName, value);
            }
            case LESS_OR_EQUAL: {
                return Filter.lessOrEqual(fieldName, value);
            }
            case GREATER_OR_EQUAL: {
                return Filter.greaterOrEqual(fieldName, value);
            }
            case LIKE: {
                return Filter.like(fieldName, value);
            }
            case NOT_LIKE: {
                return Filter.notLike(fieldName, value);
            }
            case IS_NULL: {
                return Filter.isNull(fieldName);
            }
            case NOT_NULL: {
                return Filter.notNull(fieldName);
            }
            case IN: {
                return Filter.in(fieldName, (Collection)value);
            }
            case NOT_IN: {
                return Filter.notIn(fieldName, (Collection)value);
            }
        }
        return Filter.equals(fieldName, value);
    }
}

