/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.db.mapper.Adapter;
import com.axelor.db.mapper.Property;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.rpc.Context;
import com.axelor.rpc.ContextHandlerFactory;
import com.axelor.rpc.ObjectMapperProvider;
import com.axelor.rpc.Resource;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.script.SimpleBindings;

public class JsonContext
extends SimpleBindings {
    private static final ObjectMapper jsonMapper = ObjectMapperProvider.createObjectMapper(new ModelSerializer());
    private final String jsonField;
    private final Map<String, Object> fields;
    private final Context context;

    public JsonContext(Context context, Property property, String jsonValue) {
        super(JsonContext.fromJson(jsonValue));
        this.context = context;
        this.jsonField = property.getName();
        this.fields = this.findFields();
    }

    public JsonContext(MetaJsonRecord record) {
        super(JsonContext.fromJson(Objects.requireNonNull(record).getAttrs()));
        this.context = new Context(MetaJsonRecord.class);
        this.context.put("id", (Object)record.getId());
        this.context.put("jsonModel", (Object)record.getJsonModel());
        this.jsonField = "attrs";
        this.fields = this.findFields();
    }

    private Map<String, Object> findFields() {
        String jsonModel = (String)this.context.get("jsonModel");
        if (jsonModel == null) {
            jsonModel = (String)super.get("jsonModel");
        }
        if (!StringUtils.isBlank((CharSequence)jsonModel) && MetaJsonRecord.class.isAssignableFrom(this.context.getContextClass())) {
            return MetaStore.findJsonFields(jsonModel);
        }
        return MetaStore.findJsonFields(this.context.getContextClass().getName(), this.jsonField);
    }

    private static Map<String, Object> fromJson(String text) {
        try {
            return (Map)jsonMapper.readValue(text, Map.class);
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
    }

    private static String toJson(Map<String, Object> value) {
        try {
            return jsonMapper.writeValueAsString(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void ensureManaged(Object value) {
        Model bean;
        if (value instanceof Model && ((bean = (Model)value).getId() == null || bean.getId() <= 0L)) {
            throw new IllegalArgumentException();
        }
        if (value instanceof Collection) {
            ((Collection)value).forEach(this::ensureManaged);
        }
    }

    private void propagate() {
        this.context.put(this.jsonField, (Object)JsonContext.toJson(this));
    }

    public Long getId() {
        return this.context == null ? null : (Long)this.context.get("id");
    }

    public boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    @Override
    public Object get(Object key) {
        Class<?> targetClass;
        Map field = (Map)this.fields.get(key);
        if (field == null) {
            return super.get(key);
        }
        String type = field.getOrDefault("type", "");
        Object value = super.get(key);
        if (value == null || ObjectUtils.isEmpty((Object)value)) {
            return value;
        }
        String target = null;
        switch (type) {
            case "many-to-one": 
            case "one-to-many": 
            case "many-to-many": {
                target = (String)field.get("target");
                break;
            }
            case "json-many-to-one": 
            case "json-one-to-many": 
            case "json-many-to-many": {
                target = (String)field.get("jsonTarget");
                break;
            }
            case "datetime": {
                return Adapter.adapt(value, LocalDateTime.class, null, null);
            }
            case "date": {
                return Adapter.adapt(value, LocalDate.class, null, null);
            }
            case "decimal": {
                return Adapter.adapt(value, BigDecimal.class, null, null);
            }
            case "integer": {
                return Adapter.adapt(value, Integer.class, null, null);
            }
            case "boolean": {
                return Adapter.adapt(value, Boolean.class, null, null);
            }
        }
        if (target == null) {
            return super.get(key);
        }
        try {
            targetClass = Class.forName(target);
        }
        catch (ClassNotFoundException e) {
            return super.get(key);
        }
        if (value instanceof Map) {
            return ContextHandlerFactory.newHandler(targetClass, (Map)value).getProxy();
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(item -> (Map)item).map(item -> ContextHandlerFactory.newHandler(targetClass, item).getProxy()).collect(Collectors.toList());
        }
        return super.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String name, Object value) {
        try {
            this.ensureManaged(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("cannot set unsaved values to field: " + name);
        }
        try {
            Object object = super.put(name, value);
            return object;
        }
        finally {
            this.propagate();
        }
    }

    @Override
    public Object remove(Object key) {
        try {
            Object object = super.remove(key);
            return object;
        }
        finally {
            this.propagate();
        }
    }

    static {
        jsonMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
    }

    static class ModelSerializer
    extends JsonSerializer<Model> {
        ModelSerializer() {
        }

        public void serialize(Model value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                JsonSerializer serializer = provider.findValueSerializer(Map.class, null);
                Map<String, Object> map = Resource.toMapCompact(value);
                map.remove("$version");
                serializer.serialize(map, jgen, provider);
            }
        }
    }
}

