/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaPermissions;
import com.axelor.meta.db.MetaPermissionRule;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.Help;
import com.axelor.meta.schema.views.SimpleWidget;
import com.axelor.rpc.ContextEntity;
import com.axelor.rpc.Request;
import com.axelor.rpc.Resource;
import com.axelor.script.ScriptHelper;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import groovy.lang.GString;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ObjectMapperProvider
implements Provider<ObjectMapper> {
    private final ObjectMapper mapper = ObjectMapperProvider.createObjectMapper();

    static ObjectMapper createObjectMapper() {
        return ObjectMapperProvider.createObjectMapper(new ModelSerializer());
    }

    static ObjectMapper createObjectMapper(JsonSerializer<Model> modelSerializer) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleModule module = new SimpleModule("MyModule");
        module.addSerializer(Model.class, modelSerializer);
        module.addSerializer(GString.class, (JsonSerializer)new GStringSerializer());
        module.addSerializer(BigDecimal.class, (JsonSerializer)new DecimalSerializer());
        module.setSerializerModifier((BeanSerializerModifier)new ListSerializerModifier());
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer());
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer());
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)javaTimeModule);
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new ParameterNamesModule());
        mapper.registerModule((Module)new GuavaModule());
        return mapper;
    }

    public ObjectMapper get() {
        return this.mapper;
    }

    static class ListSerializerModifier
    extends BeanSerializerModifier {
        private WidgetListSerializer listSerializer = new WidgetListSerializer();

        ListSerializerModifier() {
        }

        public JsonSerializer<?> modifyCollectionSerializer(SerializationConfig config, CollectionType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            if (AbstractWidget.class.isAssignableFrom(valueType.getContentType().getRawClass())) {
                return this.listSerializer;
            }
            return serializer;
        }
    }

    static class WidgetListSerializer
    extends JsonSerializer<List<AbstractWidget>> {
        WidgetListSerializer() {
        }

        private boolean test(AbstractWidget widget) {
            String module = widget.getModuleToCheck();
            String condition = widget.getConditionToCheck();
            if (!StringUtils.isBlank((CharSequence)module) && !ModuleManager.isInstalled(module)) {
                return false;
            }
            if (StringUtils.isBlank((CharSequence)condition)) {
                return true;
            }
            Request request = Request.current();
            if (request == null) {
                return true;
            }
            ScriptHelper helper = request.getScriptHelper();
            return helper.test(condition);
        }

        private boolean hasAccess(AbstractWidget widget) {
            MetaPermissionRule rule;
            if (!(widget instanceof SimpleWidget)) {
                return true;
            }
            SimpleWidget item = (SimpleWidget)widget;
            String object = item.getModel();
            String field = item.getName();
            User user = AuthUtils.getUser();
            if (user == null) {
                return true;
            }
            if (widget instanceof Help && user.getNoHelp() == Boolean.TRUE) {
                return false;
            }
            if (AuthUtils.isAdmin(user) || StringUtils.isBlank((CharSequence)object) || StringUtils.isBlank((CharSequence)field)) {
                return true;
            }
            MetaPermissions perms = Beans.get(MetaPermissions.class);
            if (!perms.isCollectionReadable(user, object, field)) {
                item.setHidden(true);
                item.setHideIf("true");
                item.setShowIf(null);
            }
            if ((rule = perms.findRule(user, object, field)) == null) {
                return true;
            }
            if (item.getReadonlyIf() == null && rule.getReadonlyIf() != null) {
                item.setReadonlyIf(rule.getReadonlyIf());
            }
            if (item.getHideIf() == null && rule.getHideIf() != null) {
                item.setHideIf(rule.getHideIf());
            }
            if (rule.getCanWrite() != Boolean.TRUE) {
                item.setReadonly(true);
                if (StringUtils.isBlank((CharSequence)rule.getReadonlyIf())) {
                    item.setReadonlyIf(null);
                }
            }
            return rule.getCanRead() == Boolean.TRUE;
        }

        public void serialize(List<AbstractWidget> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value == null) {
                return;
            }
            jgen.writeStartArray();
            for (AbstractWidget widget : value) {
                if (!this.test(widget) || !this.hasAccess(widget)) continue;
                jgen.writeObject((Object)widget);
            }
            jgen.writeEndArray();
        }
    }

    static class DecimalSerializer
    extends JsonSerializer<BigDecimal> {
        DecimalSerializer() {
        }

        public void serialize(BigDecimal value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                jgen.writeString(value.toPlainString());
            }
        }
    }

    static class LocalTimeSerializer
    extends JsonSerializer<LocalTime> {
        LocalTimeSerializer() {
        }

        public void serialize(LocalTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                jgen.writeString(value.format(DateTimeFormatter.ofPattern("HH:mm")));
            }
        }
    }

    static class LocalDateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        LocalDateTimeSerializer() {
        }

        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                jgen.writeString(value.atZone(ZoneOffset.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toString());
            }
        }
    }

    static class ZonedDateTimeSerializer
    extends JsonSerializer<ZonedDateTime> {
        ZonedDateTimeSerializer() {
        }

        public void serialize(ZonedDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                jgen.writeString(value.withZoneSameInstant(ZoneOffset.UTC).toString());
            }
        }
    }

    static class GStringSerializer
    extends JsonSerializer<GString> {
        GStringSerializer() {
        }

        public void serialize(GString value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                jgen.writeString(value.toString());
            }
        }
    }

    static class ModelSerializer
    extends JsonSerializer<Model> {
        ModelSerializer() {
        }

        public void serialize(Model value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                JsonSerializer serializer = provider.findValueSerializer(Map.class, null);
                Map<String, Object> map = value instanceof ContextEntity ? ((ContextEntity)((Object)value)).getContextMap() : Resource.toMap(value, new String[0]);
                serializer.serialize(map, jgen, provider);
            }
        }
    }
}

