/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.Inflector;
import com.axelor.common.StringUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.JpaSecurity;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.QueryBinder;
import com.axelor.db.ValueEnum;
import com.axelor.db.hibernate.type.JsonFunction;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.db.mapper.PropertyType;
import com.axelor.db.search.SearchService;
import com.axelor.event.Event;
import com.axelor.event.NamedLiteral;
import com.axelor.events.PostRequest;
import com.axelor.events.PreRequest;
import com.axelor.events.qualifiers.EntityTypes;
import com.axelor.i18n.I18n;
import com.axelor.i18n.I18nBundle;
import com.axelor.i18n.L10n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaPermissions;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.MetaTranslation;
import com.axelor.meta.schema.views.Selection;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.axelor.rpc.Criteria;
import com.axelor.rpc.Request;
import com.axelor.rpc.Response;
import com.axelor.rpc.Translator;
import com.axelor.rpc.filter.Filter;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.inject.TypeLiteral;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.EntityTransaction;
import javax.persistence.OptimisticLockException;
import javax.validation.ValidationException;
import org.hibernate.StaleObjectStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource<T extends Model> {
    private final Class<T> model;
    private final Provider<JpaSecurity> security;
    private final Logger LOG = LoggerFactory.getLogger(Resource.class);
    private final Event<PreRequest> preRequest;
    private final Event<PostRequest> postRequest;
    private static final int DEFAULT_EXPORT_MAX_SIZE = -1;
    private static final int DEFAULT_EXPORT_FETCH_SIZE = 500;
    private static final int EXPORT_MAX_SIZE = AppSettings.get().getInt("data.export.max-size", -1);
    private static final int EXPORT_FETCH_SIZE = AppSettings.get().getInt("data.export.fetch-size", 500);

    @Inject
    public Resource(TypeLiteral<T> typeLiteral, Provider<JpaSecurity> security, Event<PreRequest> preRequest, Event<PostRequest> postRequest) {
        this.model = typeLiteral.getRawType();
        this.security = security;
        this.preRequest = preRequest;
        this.postRequest = postRequest;
    }

    public Class<?> getModel() {
        return this.model;
    }

    private Long findId(Map<String, Object> values) {
        try {
            return Long.parseLong(values.get("id").toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void firePreRequestEvent(String source, Request request) {
        this.preRequest.select(new Annotation[]{NamedLiteral.of(source), EntityTypes.type(this.model)}).fire(new PreRequest(source, request));
    }

    private void firePostRequestEvent(String source, Request request, Response response) {
        this.postRequest.select(new Annotation[]{NamedLiteral.of(source), EntityTypes.type(this.model)}).fire(new PostRequest(source, request, response));
    }

    private Request newRequest(Request from, Long ... records) {
        Request request = new Request();
        request.setModel(this.model.getName());
        List<Object> items = Stream.of(records).map(item -> ImmutableMap.of((Object)"id", (Object)item)).collect(Collectors.toList());
        request.setRecords(items);
        if (from != null) {
            request.setData(from.getData());
            request.setFields(from.getFields());
            if (items.isEmpty()) {
                request.setRecords(from.getRecords());
            }
        }
        return request;
    }

    public Response fields() {
        Response response = new Response();
        JpaRepository<T> repository = JpaRepository.of(this.model);
        HashMap meta = Maps.newHashMap();
        ArrayList fields = Lists.newArrayList();
        if (repository == null) {
            for (Property p : JPA.fields(this.model)) {
                fields.add(p.toMap());
            }
        } else {
            for (Property p : repository.fields()) {
                fields.add(p.toMap());
            }
        }
        meta.put("model", this.model.getName());
        meta.put("fields", fields);
        response.setData(meta);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    public static Response models(Request request) {
        Response response = new Response();
        ArrayList data = Lists.newArrayList();
        for (Class<?> type : JPA.models()) {
            data.add(type.getName());
        }
        Collections.sort(data);
        response.setData(ImmutableList.copyOf((Collection)data));
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    public Response perms() {
        Set<JpaSecurity.AccessType> perms = ((JpaSecurity)this.security.get()).getAccessTypes(this.model, null);
        Response response = new Response();
        response.setData(perms);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    public Response perms(Long id) {
        Set<JpaSecurity.AccessType> perms = ((JpaSecurity)this.security.get()).getAccessTypes(this.model, id);
        Response response = new Response();
        response.setData(perms);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    public Response perms(Long id, String perm) {
        Response response = new Response();
        JpaSecurity sec = (JpaSecurity)this.security.get();
        JpaSecurity.AccessType type = JpaSecurity.CAN_READ;
        try {
            type = JpaSecurity.AccessType.valueOf(perm.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            sec.check(type, this.model, id);
            response.setStatus(Response.STATUS_SUCCESS);
        }
        catch (Exception e) {
            response.addError(perm, e.getMessage());
            response.setStatus(Response.STATUS_VALIDATION_ERROR);
        }
        return response;
    }

    private List<String> getSortBy(Request request) {
        ArrayList sortBy = Lists.newArrayList();
        ArrayList sortOn = Lists.newArrayList();
        Mapper mapper = Mapper.of(this.model);
        boolean unique = false;
        boolean desc = true;
        if (request.getSortBy() != null) {
            sortOn.addAll(request.getSortBy());
        }
        if (sortOn.isEmpty()) {
            Property nameField = mapper.getNameField();
            if (nameField == null) {
                nameField = mapper.getProperty("name");
            }
            if (nameField == null) {
                nameField = mapper.getProperty("code");
            }
            if (nameField != null) {
                sortOn.add(nameField.getName());
            }
        }
        for (String spec : sortOn) {
            Mapper m;
            Property p;
            String name = spec;
            if (name.startsWith("-")) {
                name = name.substring(1);
            } else {
                desc = false;
            }
            Property property = mapper.getProperty(name);
            if (property == null || property.isPrimary()) {
                sortBy.add(spec);
                continue;
            }
            if (property.isReference() && (p = (m = Mapper.of(property.getTarget())).getNameField()) != null) {
                spec = spec + "." + p.getName();
            }
            if (property.isUnique() && property.isRequired()) {
                unique = true;
            }
            sortBy.add(spec);
        }
        if (!(unique || sortBy.contains("id") || sortBy.contains("-id"))) {
            sortBy.add(desc ? "-id" : "id");
        }
        return sortBy;
    }

    private Criteria getCriteria(Request request) {
        Object domain;
        if (request.getData() != null && (domain = request.getData().get("_domain")) != null) {
            try {
                String qs = request.getCriteria().createQuery(this.model).toString();
                JPA.em().createQuery(qs);
            }
            catch (Exception e) {
                this.LOG.error("Error: " + e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException("Invalid domain: " + domain, e);
            }
        }
        return request.getCriteria();
    }

    private boolean shouldCheckPermissions(Request request) {
        Context context = request.getContext();
        if (context != null && context.containsKey("_field") && context.containsKey("_field_ids") && context.containsKey("id")) {
            Model parent = context.asType(Model.class);
            return !((JpaSecurity)this.security.get()).isPermitted(JpaSecurity.CAN_READ, EntityHelper.getEntityClass(parent), parent.getId());
        }
        return true;
    }

    private Query<?> getQuery(Request request) {
        return this.getQuery(request, ((JpaSecurity)this.security.get()).getFilter(JpaSecurity.CAN_READ, this.model, new Long[0]));
    }

    private Query<?> getQuery(Request request, Filter filter) {
        Criteria criteria = this.getCriteria(request);
        Query<T> query = JPA.all(this.model);
        if (criteria != null) {
            query = criteria.createQuery(this.model, filter);
        } else if (filter != null) {
            query = filter.build(this.model);
        }
        for (String spec : this.getSortBy(request)) {
            query = query.order(spec);
        }
        return query;
    }

    private Query<?> getSearchQuery(Request request, Filter filter) {
        SearchService searchService = Beans.get(SearchService.class);
        if (request.getData() == null || !searchService.isEnabled()) {
            return this.getQuery(request, filter);
        }
        Map<String, Object> data = request.getData();
        String searchText = (String)data.get("_searchText");
        if (!StringUtils.isEmpty((CharSequence)searchText)) {
            try {
                List<Long> ids = searchService.fullTextSearch(this.model, searchText, request.getLimit());
                if (ids.size() > 0) {
                    return JPA.all(this.model).filter("self.id in :ids").bind("ids", ids);
                }
            }
            catch (Exception e) {
                this.LOG.error("Unable to do full-text search: " + e.getMessage(), (Throwable)e);
            }
        }
        return filter == null ? this.getQuery(request) : this.getQuery(request, filter);
    }

    /*
     * WARNING - void declaration
     */
    public Response search(Request request) {
        boolean check;
        Filter filter = ((JpaSecurity)this.security.get()).getFilter(JpaSecurity.CAN_READ, this.model, new Long[0]);
        boolean bl = check = filter == null || this.shouldCheckPermissions(request);
        if (check) {
            ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_READ, this.model, new Long[0]);
        }
        this.LOG.debug("Searching '{}' with {}", (Object)this.model.getCanonicalName(), request.getData());
        this.firePreRequestEvent("search", request);
        Response response = new Response();
        int offset = request.getOffset();
        int limit = request.getLimit();
        Query<?> query = this.getSearchQuery(request, check ? filter : null).readOnly();
        List<Object> data = null;
        try {
            if (limit > 0) {
                response.setTotal(query.count());
            }
            if (request.getFields() != null) {
                Query.Selector selector = query.select(request.getFields().toArray(new String[0]));
                this.LOG.debug("JPQL: {}", (Object)selector);
                data = selector.fetch(limit, offset);
            } else {
                this.LOG.debug("JPQL: {}", query);
                data = query.fetch(limit, offset);
            }
            if (limit <= 0) {
                response.setTotal(data.size());
            }
        }
        catch (Exception e) {
            EntityTransaction txn = JPA.em().getTransaction();
            if (txn.isActive()) {
                txn.rollback();
            }
            data = Lists.newArrayList();
            this.LOG.error("Error: {}", (Object)e, (Object)e);
        }
        this.LOG.debug("Records found: {}", (Object)data.size());
        JpaRepository<T> repo = JpaRepository.of(this.model);
        ArrayList<void> jsonData = new ArrayList<void>();
        boolean populate = request.getContext() != null && request.getContext().get("_populate") != Boolean.FALSE;
        for (Object object : data) {
            void var13_15;
            void var13_18;
            if (object instanceof Model) {
                Map<String, Object> map = Resource.toMap(object, new String[0]);
            }
            if (var13_18 instanceof Map) {
                Map map = (Map)var13_18;
                if (User.class.isAssignableFrom(this.model)) {
                    map.remove("password");
                }
                if (populate) {
                    Map<String, Object> map2 = repo.populate(map, request.getContext());
                }
                Translator.applyTranslatables(map, this.model);
            }
            jsonData.add(var13_15);
        }
        try {
            this.doChildCount(request, jsonData);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        response.setData(jsonData);
        response.setOffset(offset);
        response.setStatus(Response.STATUS_SUCCESS);
        this.firePostRequestEvent("search", request, response);
        return response;
    }

    private void doChildCount(Request request, List<?> result) throws NullPointerException, ClassCastException {
        if (result == null || result.isEmpty()) {
            return;
        }
        Map context = (Map)request.getData().get("_domainContext");
        Map childOn = (Map)context.get("_childOn");
        String countOn = (String)context.get("_countOn");
        if (countOn == null && childOn == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        ArrayList ids = Lists.newArrayList();
        for (Object item : result) {
            ids.add(((Map)item).get("id"));
        }
        String modelName = this.model.getName();
        String parentName = countOn;
        if (childOn != null) {
            modelName = (String)childOn.get("model");
            parentName = (String)childOn.get("parent");
        }
        builder.append("SELECT new map(_parent.id as id, count(self.id) as count) FROM ").append(modelName).append(" self ").append("LEFT JOIN self.").append(parentName).append(" AS _parent ").append("WHERE _parent.id IN (:ids) GROUP BY _parent");
        javax.persistence.Query q = JPA.em().createQuery(builder.toString());
        q.setParameter("ids", (Object)ids);
        QueryBinder.of(q).setReadOnly();
        HashMap counts = Maps.newHashMap();
        for (Object item : q.getResultList()) {
            counts.put(((Map)item).get("id"), ((Map)item).get("count"));
        }
        for (Object item : result) {
            ((Map)item).put("_children", counts.get(((Map)item).get("id")));
        }
    }

    public int export(Request request, Writer writer) throws IOException {
        String name2;
        ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_READ, this.model, new Long[0]);
        ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_EXPORT, this.model, new Long[0]);
        this.LOG.debug("Exporting '{}' with {}", (Object)this.model.getName(), request.getData());
        this.firePreRequestEvent("export", request);
        List<String> fields = request.getFields();
        ArrayList<String> header = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        HashMap selection = new HashMap();
        HashMap jsonFieldsMap = new HashMap();
        Mapper mapper = Mapper.of(this.model);
        MetaPermissions perms = Beans.get(MetaPermissions.class);
        Function findJsonFields = name -> jsonFieldsMap.computeIfAbsent(name, n -> MetaJsonRecord.class.isAssignableFrom(this.model) ? MetaStore.findJsonFields((String)request.getContext().get("jsonModel")) : MetaStore.findJsonFields(this.model.getName(), n));
        Function findJsonPaths = name -> {
            Map map = (Map)findJsonFields.apply(name);
            return map == null ? Collections.EMPTY_LIST : map.keySet().stream().map(n -> name + "." + n).collect(Collectors.toList());
        };
        if (fields == null) {
            fields = new ArrayList<String>();
        }
        if (fields.isEmpty() && MetaJsonRecord.class.isAssignableFrom(this.model)) {
            fields.add("id");
            fields.addAll((Collection)findJsonPaths.apply((Object)"attrs"));
        }
        if (fields.isEmpty()) {
            fields.add("id");
            try {
                fields.add(mapper.getNameField().getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Property property : mapper.getProperties()) {
                if (property.isPrimary() || property.isTransient() || property.isVersion() || property.isCollection() || property.isPassword() || property.getType() == PropertyType.BINARY || fields.contains(name2 = property.getName()) || name2.matches("^(created|updated)(On|By)$")) continue;
                if (property.isJson()) {
                    fields.addAll((Collection)findJsonPaths.apply((Object)property.getName()));
                    continue;
                }
                fields.add(name2);
            }
        }
        for (String field : fields) {
            Iterator iter = Splitter.on((String)".").split((CharSequence)field).iterator();
            Property prop = mapper.getProperty((String)iter.next());
            while (iter.hasNext() && prop != null && !prop.isJson()) {
                prop = Mapper.of(prop.getTarget()).getProperty((String)iter.next());
            }
            if (prop == null || prop.isCollection() || prop.isTransient() || prop.getType() == PropertyType.BINARY || prop.isJson() && !iter.hasNext()) continue;
            name2 = prop.getName();
            String title = prop.getTitle();
            String model = this.getModel().getName();
            if (prop.isReference()) {
                model = prop.getTarget().getName();
            }
            if (!perms.canExport(AuthUtils.getUser(), model, name2)) continue;
            if (iter != null) {
                name2 = field;
            }
            List options = MetaStore.getSelectionList(prop.getSelection());
            if (prop.isJson()) {
                Map jsonFields = (Map)findJsonFields.apply((Object)prop.getName());
                Map jsonField = (Map)jsonFields.get(iter.next());
                name2 = field;
                if (jsonField != null) {
                    title = (String)jsonField.get("title");
                    if (title == null) {
                        title = (String)jsonField.get("autoTitle");
                    }
                    options = (List)jsonField.get("selectionList");
                    if ("many-to-one".equals(jsonField.get("type"))) {
                        try {
                            String targetName = jsonField.get("targetName").toString();
                            targetName = targetName.substring(targetName.indexOf(".") + 1);
                            name2 = name2 + "." + targetName;
                        }
                        catch (Exception targetName) {
                            // empty catch block
                        }
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)title)) {
                title = Inflector.getInstance().humanize(prop.getName());
            }
            if (prop.isReference()) {
                if ((prop = Mapper.of(prop.getTarget()).getNameField()) == null) continue;
                name2 = name2 + '.' + prop.getName();
            } else if (options != null && !options.isEmpty()) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (Selection.Option option : options) {
                    map.put(option.getValue(), option.getLocalizedTitle());
                }
                selection.put(header.size(), map);
            }
            title = I18n.get(title);
            names.add(name2);
            header.add(this.escapeCsv(title));
        }
        writer.write(Joiner.on((String)";").join(header));
        int limit = EXPORT_MAX_SIZE > 0 ? Math.min(EXPORT_FETCH_SIZE, EXPORT_MAX_SIZE) : EXPORT_FETCH_SIZE;
        int offset = 0;
        int count = 0;
        Query<?> query = this.getQuery(request);
        Query.Selector selector = query.select(names.toArray(new String[0]));
        List<List> data = selector.values(limit, offset);
        L10n formatter = L10n.getInstance();
        while (!data.isEmpty()) {
            Iterator<List> options = data.iterator();
            while (options.hasNext()) {
                List item;
                List row = item = options.next();
                ArrayList<String> line = new ArrayList<String>();
                int index = 0;
                for (Object value : row) {
                    String objValue;
                    if (index++ < 2) continue;
                    String string = objValue = value == null ? "" : value;
                    if (selection.containsKey(index - 3)) {
                        objValue = ((Map)selection.get(index - 3)).get(objValue.toString());
                    }
                    if (objValue instanceof Number) {
                        objValue = formatter.format((Number)((Object)objValue), false);
                    }
                    if (objValue instanceof LocalDate) {
                        objValue = formatter.format((LocalDate)((Object)objValue));
                    }
                    if (objValue instanceof LocalDateTime) {
                        objValue = formatter.format((LocalDateTime)((Object)objValue));
                    }
                    if (objValue instanceof ZonedDateTime) {
                        objValue = formatter.format((ZonedDateTime)((Object)objValue));
                    }
                    String strValue = objValue == null ? "" : this.escapeCsv(objValue.toString());
                    line.add(strValue);
                }
                writer.write("\n");
                writer.write(Joiner.on((String)";").join(line));
            }
            count += data.size();
            int nextLimit = limit;
            if (EXPORT_MAX_SIZE > -1) {
                if (count >= EXPORT_MAX_SIZE) break;
                nextLimit = Math.min(limit, EXPORT_MAX_SIZE - count);
            }
            data = selector.values(nextLimit, offset += limit);
        }
        Response response = new Response();
        response.setTotal(count);
        this.firePostRequestEvent("export", request, response);
        return count;
    }

    private String escapeCsv(String value) {
        if (value == null) {
            return "";
        }
        if (value.indexOf(34) > -1) {
            value = value.replaceAll("\"", "\"\"");
        }
        return '\"' + value + '\"';
    }

    public Response read(long id) {
        ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_READ, this.model, id);
        Request request = this.newRequest(null, id);
        Response response = new Response();
        ArrayList data = Lists.newArrayList();
        this.firePreRequestEvent("read", request);
        T entity = JPA.find(this.model, id);
        if (entity != null) {
            data.add(entity);
        }
        response.setData(data);
        response.setStatus(Response.STATUS_SUCCESS);
        this.firePostRequestEvent("read", request, response);
        return response;
    }

    public Response fetch(long id, Request request) {
        ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_READ, this.model, id);
        Request req = this.newRequest(request, id);
        this.firePreRequestEvent("fetch", req);
        Response response = new Response();
        JpaRepository<T> repository = JpaRepository.of(this.model);
        Object entity = repository.find(id);
        if (entity == null) {
            throw new OptimisticLockException((Throwable)new StaleObjectStateException(this.model.getName(), (Serializable)Long.valueOf(id)));
        }
        response.setStatus(Response.STATUS_SUCCESS);
        ArrayList data = Lists.newArrayList();
        String[] fields = request.getFields() == null ? null : request.getFields().toArray(new String[0]);
        Map<String, Object> values = this.mergeRelated(request, (Model)entity, Resource.toMap(entity, fields));
        data.add(repository.populate(values, request.getContext()));
        response.setData(data);
        this.firePostRequestEvent("fetch", req, response);
        return response;
    }

    private Map<String, Object> mergeRelated(Request request, Model entity, Map<String, Object> values) {
        Map<String, List<String>> related = request.getRelated();
        if (related == null) {
            return values;
        }
        Mapper mapper = Mapper.of(this.model);
        related.entrySet().stream().filter(e -> e.getValue() != null).filter(e -> ((List)e.getValue()).size() > 0).forEach(e -> {
            String name = (String)e.getKey();
            String[] names = ((List)e.getValue()).toArray(new String[0]);
            Object old = values.get(name);
            Map<String, Object> value = mapper.get(entity, name);
            if (value instanceof Collection) {
                value = ((Collection)((Object)value)).stream().map(input -> Resource.toMap(input, names)).collect(Collectors.toList());
            } else if (value instanceof Model) {
                value = Resource.toMap(value, names);
                if (old instanceof Map) {
                    value = this.mergeMaps(value, (Map)old);
                }
            }
            values.put(name, value);
        });
        return values;
    }

    private Map<String, Object> mergeMaps(Map<String, Object> target, Map<String, Object> source) {
        if (target == null || source == null || source.isEmpty()) {
            return target;
        }
        for (String key : source.keySet()) {
            Object old = source.get(key);
            Object val = target.get(key);
            if (val instanceof Map && old instanceof Map) {
                this.mergeMaps((Map)val, (Map)old);
                continue;
            }
            if (val != null) continue;
            target.put(key, old);
        }
        return target;
    }

    public Response verify(Request request) {
        Response response = new Response();
        try {
            JPA.verify(this.model, request.getData());
            response.setStatus(Response.STATUS_SUCCESS);
        }
        catch (OptimisticLockException e) {
            response.setStatus(Response.STATUS_VALIDATION_ERROR);
        }
        return response;
    }

    private User changeUserPassword(User user, Map<String, Object> values) {
        String oldPassword = (String)values.get("oldPassword");
        String newPassword = (String)values.get("newPassword");
        String chkPassword = (String)values.get("chkPassword");
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            if (values.get("blocked") != null) {
                user.setPasswordUpdatedOn(LocalDateTime.now());
            }
            return user;
        }
        if (StringUtils.isBlank((CharSequence)oldPassword)) {
            throw new ValidationException("Current user password is not provided.");
        }
        if (!newPassword.equals(chkPassword)) {
            throw new ValidationException("Confirm password doesn't match with new password.");
        }
        User current = AuthUtils.getUser();
        AuthService authService = AuthService.getInstance();
        if (!authService.match(oldPassword, current.getPassword())) {
            throw new ValidationException("Current user password is wrong.");
        }
        authService.changePassword(user, newPassword);
        return user;
    }

    @Transactional
    public Response save(Request request) {
        Response response = new Response();
        JpaRepository<T> repository = JpaRepository.of(this.model);
        ArrayList records = request.getRecords();
        ArrayList data = Lists.newArrayList();
        this.firePreRequestEvent("save", request);
        if ((records == null || records.isEmpty()) && request.getData() == null) {
            response.setStatus(Response.STATUS_FAILURE);
            this.firePostRequestEvent("save", request, response);
            return response;
        }
        if (records == null) {
            records = Lists.newArrayList();
            records.add(request.getData());
        }
        String[] names = new String[]{};
        if (request.getFields() != null) {
            names = request.getFields().toArray(names);
        }
        for (Object record : records) {
            JpaSecurity.AccessType accessType;
            if (record == null) continue;
            Long id = this.findId((Map)(record = repository.validate((Map)record, request.getContext())));
            JpaSecurity.AccessType accessType2 = accessType = id == null || id <= 0L ? JpaSecurity.CAN_CREATE : JpaSecurity.CAN_WRITE;
            if (id == null || id <= 0L) {
                ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_CREATE, this.model, new Long[0]);
            }
            Map orig = (Map)((Map)record).get("_original");
            JPA.verify(this.model, orig);
            T bean = JPA.edit(this.model, (Map)record);
            id = ((Model)bean).getId();
            if (bean != null && id != null && id > 0L) {
                ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_WRITE, this.model, id);
            }
            if (bean instanceof User) {
                this.changeUserPassword((User)bean, (Map)record);
            }
            bean = JPA.manage(bean);
            if (repository != null) {
                bean = repository.save(bean);
            }
            ((JpaSecurity)this.security.get()).check(accessType, this.model, ((Model)bean).getId());
            if (bean instanceof MetaTranslation) {
                I18nBundle.invalidate();
            }
            data.add(repository.populate(Resource.toMap(bean, names), request.getContext()));
        }
        response.setData(data);
        response.setStatus(Response.STATUS_SUCCESS);
        this.firePostRequestEvent("save", request, response);
        return response;
    }

    @Transactional
    public Response updateMass(Request request) {
        ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_WRITE, this.model, new Long[0]);
        this.LOG.debug("Mass update '{}' with {}", (Object)this.model.getCanonicalName(), request.getData());
        this.firePreRequestEvent("mass-update", request);
        Response response = new Response();
        Query<?> query = this.getQuery(request);
        List<Object> data = request.getRecords();
        this.LOG.debug("JPQL: {}", query);
        Map values = (Map)data.get(0);
        response.setTotal(query.update(values, AuthUtils.getUser()));
        this.LOG.debug("Records updated: {}", (Object)response.getTotal());
        response.setStatus(Response.STATUS_SUCCESS);
        this.firePostRequestEvent("mass-update", request, response);
        return response;
    }

    @Transactional
    public Response remove(long id, Request request) {
        ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_REMOVE, this.model, id);
        Response response = new Response();
        JpaRepository<T> repository = JpaRepository.of(this.model);
        HashMap data = Maps.newHashMap();
        data.put("id", id);
        data.put("version", request.getData().get("version"));
        Request req = this.newRequest(request, id);
        this.firePreRequestEvent("remove", request);
        T bean = JPA.edit(this.model, data);
        if (((Model)bean).getId() != null) {
            if (repository == null) {
                JPA.remove(bean);
            } else {
                repository.remove(bean);
            }
        }
        response.setData(ImmutableList.of(Resource.toMapCompact(bean)));
        response.setStatus(Response.STATUS_SUCCESS);
        this.firePostRequestEvent("remove", req, response);
        return response;
    }

    @Transactional
    public Response remove(Request request) {
        Response response = new Response();
        JpaRepository<Model> repository = JpaRepository.of(this.model);
        List<Object> records = request.getRecords();
        if (records == null || records.isEmpty()) {
            return response.fail("No records provides.");
        }
        this.firePreRequestEvent("remove", request);
        ArrayList entities = Lists.newArrayList();
        for (Object record : records) {
            Map map = (Map)record;
            Long id = Longs.tryParse((String)map.get("id").toString());
            Integer version = null;
            try {
                version = Ints.tryParse((String)map.get("version").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_REMOVE, this.model, id);
            T bean = JPA.find(this.model, id);
            if (bean == null || version != null && !Objects.equal((Object)version, (Object)((Model)bean).getVersion())) {
                throw new OptimisticLockException((Throwable)new StaleObjectStateException(this.model.getName(), (Serializable)id));
            }
            entities.add(bean);
        }
        for (Model entity : entities) {
            if (repository == null) {
                JPA.remove(entity);
                continue;
            }
            repository.remove(entity);
        }
        response.setData(records);
        response.setStatus(Response.STATUS_SUCCESS);
        this.firePostRequestEvent("remove", request, response);
        return response;
    }

    private void fixLinks(Object bean) {
        if (bean == null) {
            return;
        }
        Mapper mapper = Mapper.of(EntityHelper.getEntityClass(bean));
        for (Property prop : mapper.getProperties()) {
            if (prop.getType() != PropertyType.ONE_TO_MANY || prop.get(bean) == null) continue;
            for (Object item : (Collection)prop.get(bean)) {
                prop.setAssociation(item, null);
                this.fixLinks(item);
            }
        }
    }

    public Response copy(long id) {
        ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_CREATE, this.model, id);
        Request request = this.newRequest(null, id);
        Response response = new Response();
        JpaRepository<T> repository = JpaRepository.of(this.model);
        request.setRecords(Lists.newArrayList((Object[])new Object[]{id}));
        this.firePreRequestEvent("copy", request);
        T bean = JPA.find(this.model, id);
        bean = repository == null ? JPA.copy(bean, true) : repository.copy(bean, true);
        this.fixLinks(bean);
        response.setData(ImmutableList.of(bean));
        response.setStatus(Response.STATUS_SUCCESS);
        this.firePostRequestEvent("copy", request, response);
        return response;
    }

    public ActionResponse action(ActionRequest request) {
        ActionResponse response = new ActionResponse();
        String[] parts = request.getAction().split("\\:");
        if (parts.length != 2) {
            response.setStatus(Response.STATUS_FAILURE);
            return response;
        }
        String controller = parts[0];
        String method = parts[1];
        try {
            Class<?> klass = Class.forName(controller);
            Method m = klass.getDeclaredMethod(method, ActionRequest.class, ActionResponse.class);
            Object obj = Beans.get(klass);
            m.setAccessible(true);
            m.invoke(obj, request, response);
            response.setStatus(Response.STATUS_SUCCESS);
        }
        catch (Exception e) {
            this.LOG.debug(e.toString(), (Throwable)e);
            response.setException(e);
        }
        return response;
    }

    public Response getRecordName(Request request) {
        JsonFunction func;
        Property p;
        Response response = new Response();
        Mapper mapper = Mapper.of(this.model);
        Map<String, Object> data = request.getData();
        String name = request.getFields().get(0);
        if (name == null) {
            name = "id";
        }
        Property property = null;
        try {
            property = mapper.getProperty(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String selectName = null;
        if (property == null && name.indexOf(46) > -1 && (p = mapper.getProperty((func = JsonFunction.fromPath(name)).getField())) != null && p.isJson()) {
            selectName = func.toString();
        }
        if (property == null && selectName == null) {
            property = mapper.getNameField();
        }
        if (property != null && selectName == null) {
            selectName = "self." + property.getName();
            name = property.getName();
        }
        Request req = this.newRequest(null, new Long[0]);
        req.setFields(Lists.newArrayList((Object[])new String[]{selectName}));
        req.setRecords(Lists.newArrayList((Object[])new Object[]{data}));
        this.firePreRequestEvent("fetch:name", req);
        if (selectName != null) {
            String qs = String.format("SELECT %s FROM %s self WHERE self.id = :id", selectName, this.model.getSimpleName());
            javax.persistence.Query query = JPA.em().createQuery(qs);
            QueryBinder.of(query).setCacheable().setReadOnly().bind(data, new Object[0]);
            Object value = query.getSingleResult();
            data.put(name, value);
        }
        response.setData(ImmutableList.of(data));
        response.setStatus(Response.STATUS_SUCCESS);
        this.firePostRequestEvent("fetch:name", req, response);
        return response;
    }

    public boolean isPermitted(JpaSecurity.AccessType accessType, Long id) {
        return ((JpaSecurity)this.security.get()).isPermitted(accessType, this.model, id);
    }

    public static Map<String, Object> toMap(Object bean, String ... names) {
        return Resource._toMap(bean, Resource.unflatten(null, names), false, 0);
    }

    public static Map<String, Object> toMapCompact(Object bean) {
        return Resource._toMap(bean, null, true, 1);
    }

    private static Map<String, Object> _toMap(Object bean, Map<String, Object> fields, boolean compact, int level) {
        if (bean == null) {
            return null;
        }
        bean = EntityHelper.getEntity(bean);
        if (fields == null) {
            fields = Maps.newHashMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Mapper mapper = Mapper.of(bean.getClass());
        boolean isSaved = ((Model)bean).getId() != null;
        boolean isCompact = compact || fields.containsKey("$version");
        HashSet translatables = new HashSet();
        if (isCompact && isSaved || isSaved && level >= 1 || level > 1) {
            Property pn = mapper.getNameField();
            Property pc = mapper.getProperty("code");
            result.put("id", mapper.get(bean, "id"));
            result.put("$version", mapper.get(bean, "version"));
            if (pn != null) {
                result.put(pn.getName(), mapper.get(bean, pn.getName()));
            }
            if (pc != null) {
                result.put(pc.getName(), mapper.get(bean, pc.getName()));
            }
            if (pn != null && pn.isTranslatable()) {
                Translator.translate(result, pn);
            }
            if (pc != null && pc.isTranslatable()) {
                Translator.translate(result, pc);
            }
            for (String name : fields.keySet()) {
                Map<String, Object> child = mapper.get(bean, name);
                if (child instanceof Model) {
                    child = Resource._toMap(child, (Map)fields.get(name), true, level + 1);
                }
                if (child == null) continue;
                result.put(name, child);
            }
            return result;
        }
        for (Property prop : mapper.getProperties()) {
            MetaAction act;
            Object enumValue;
            String enumName;
            String name = prop.getName();
            PropertyType type = prop.getType();
            if (type == PropertyType.BINARY || prop.isPassword() || isSaved && !name.matches("id|version|archived") && !fields.isEmpty() && !fields.containsKey(name)) continue;
            Object value = mapper.get(bean, name);
            if (name.equals("archived") && value == null) continue;
            if (prop.isImage() && byte[].class.isInstance(value)) {
                value = new String((byte[])value);
            }
            if (value instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)value;
                int scale = prop.getScale();
                if (decimal.scale() == 0 && scale > 0 && scale != decimal.scale()) {
                    value = decimal.setScale(scale, RoundingMode.HALF_UP);
                }
            }
            if (value instanceof Model) {
                Map _fields = (Map)fields.get(prop.getName());
                value = Resource._toMap(value, _fields, true, level + 1);
            }
            if (value instanceof Collection) {
                ArrayList items = Lists.newArrayList();
                for (Model input : (Collection)value) {
                    Map<String, Object> item = input.getId() != null ? Resource._toMap(input, null, true, level + 1) : Resource._toMap(input, null, false, 1);
                    if (item == null) continue;
                    items.add(item);
                }
                value = items;
            }
            result.put(name, value);
            if (prop.isTranslatable() && value instanceof String) {
                Translator.translate(result, prop);
            }
            if (prop.isEnum() && value instanceof ValueEnum && !Objects.equal((Object)(enumName = ((Enum)value).name()), enumValue = ((ValueEnum)value).getValue())) {
                result.put(name + "$value", ((ValueEnum)value).getValue());
            }
            if (result.get("homeAction") == null || (act = JpaRepository.of(MetaAction.class).all().filter("self.name = ?", result.get("homeAction")).fetchOne()) == null) continue;
            result.put("__actionSelect", Resource.toMapCompact(act));
        }
        return result;
    }

    private static Map<String, Object> unflatten(Map<String, Object> map, String ... names) {
        if (map == null) {
            map = Maps.newHashMap();
        }
        if (names == null) {
            return map;
        }
        for (String name : names) {
            if (map.containsKey(name)) continue;
            if (name.contains(".")) {
                String[] parts = name.split("\\.", 2);
                Map child = (Map)map.get(parts[0]);
                if (child == null) {
                    child = Maps.newHashMap();
                }
                map.put(parts[0], Resource.unflatten(child, parts[1]));
                continue;
            }
            map.put(name, Maps.newHashMap());
        }
        return map;
    }
}

