/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.app.AppSettings;
import com.axelor.i18n.I18n;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;
import com.google.common.base.Throwables;
import java.sql.BatchUpdateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Response {
    public static int STATUS_FAILURE = -1;
    public static int STATUS_LOGIN_INCORRECT = -5;
    public static int STATUS_LOGIN_REQUIRED = -7;
    public static int STATUS_LOGIN_SUCCESS = -8;
    public static int STATUS_MAX_LOGIN_ATTEMPTS_EXCEEDED = -6;
    public static int STATUS_SERVER_TIMEOUT = -100;
    public static int STATUS_SUCCESS = 0;
    public static int STATUS_TRANSPORT_ERROR = -90;
    public static int STATUS_VALIDATION_ERROR = -4;
    private int status;
    @JsonSerialize(using=OffsetSerializer.class)
    private int offset = -1;
    @JsonSerialize(using=TotalSerializer.class)
    private long total = -1L;
    private Object data;
    private Map<String, String> errors;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long count) {
        this.total = count;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public void setErrors(Map<String, String> errors) {
        this.errors = errors;
    }

    public void addError(String fieldName, String errorMessage) {
        if (this.errors == null) {
            this.errors = new HashMap<String, String>();
        }
        this.errors.put(fieldName, errorMessage);
    }

    public Response fail(String message) {
        HashMap<String, String> report = new HashMap<String, String>();
        report.put("message", message);
        this.setData(report);
        this.setStatus(STATUS_FAILURE);
        return this;
    }

    public void setException(Throwable throwable) {
        String message;
        HashMap<String, Object> report = new HashMap<String, Object>();
        Throwable cause = Throwables.getRootCause((Throwable)throwable);
        if (cause instanceof BatchUpdateException) {
            cause = ((BatchUpdateException)cause).getNextException();
        }
        if ((message = throwable.getMessage()) == null || message.startsWith(cause.getClass().getName())) {
            message = cause.getMessage();
        }
        if (AppSettings.get().isProduction()) {
            report.put("title", I18n.get("Internal Server Error"));
            report.put("message", message);
            report.put("popup", true);
        } else {
            report.put("class", throwable.getClass());
            report.put("message", message);
            report.put("string", cause.toString());
            report.put("stacktrace", Throwables.getStackTraceAsString((Throwable)throwable));
            report.put("cause", Throwables.getStackTraceAsString((Throwable)cause));
        }
        this.setData(report);
        this.setStatus(STATUS_FAILURE);
    }

    public Object getItem(int index) {
        try {
            return ((List)this.data).get(index);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class TotalSerializer
    extends NumberSerializer {
        public TotalSerializer() {
            super(Long.class);
        }

        public boolean isEmpty(SerializerProvider provider, Number value) {
            return value == null || value.longValue() == -1L;
        }
    }

    private static class OffsetSerializer
    extends NumberSerializer {
        public OffsetSerializer() {
            super(Integer.class);
        }

        public boolean isEmpty(SerializerProvider provider, Number value) {
            return value == null || value.intValue() == -1;
        }
    }
}

