/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.auth.AuthSecurityException;
import com.axelor.auth.AuthUtils;
import com.axelor.common.crypto.EncryptorException;
import com.axelor.db.JpaSecurity;
import com.axelor.db.JpaSupport;
import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.axelor.rpc.Response;
import com.google.common.base.Throwables;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.persistence.EntityTransaction;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseInterceptor
extends JpaSupport
implements MethodInterceptor {
    private final Logger log = LoggerFactory.getLogger(ResponseInterceptor.class);
    private final ThreadLocal<Boolean> running = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.running.get() == Boolean.TRUE) {
            return invocation.proceed();
        }
        this.log.trace("Web Service: {}", (Object)invocation.getMethod());
        Response response = null;
        this.running.set(true);
        try {
            response = (Response)invocation.proceed();
        }
        catch (Exception e) {
            EntityTransaction txn = this.getEntityManager().getTransaction();
            if (txn.isActive()) {
                txn.rollback();
            } else if (e instanceof PersistenceException) {
                try {
                    txn.begin();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                response = new Response();
                response = this.onException(e, response);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Exception: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            finally {
                if (txn.isActive()) {
                    txn.rollback();
                }
            }
        }
        finally {
            this.running.remove();
        }
        return response;
    }

    private Response onException(Throwable throwable, Response response) {
        Throwable cause = throwable.getCause();
        Throwable root = Throwables.getRootCause((Throwable)throwable);
        for (Throwable ex : Arrays.asList(throwable, cause, root)) {
            if (ex instanceof AuthorizationException) {
                return this.onAuthorizationException((AuthorizationException)ex, response);
            }
            if (ex instanceof AuthSecurityException) {
                return this.onAuthSecurityException((AuthSecurityException)ex, response);
            }
            if (ex instanceof OptimisticLockException) {
                return this.onOptimisticLockException((OptimisticLockException)ex, response);
            }
            if (ex instanceof ConstraintViolationException) {
                return this.onConstraintViolationException((ConstraintViolationException)ex, response);
            }
            if (ex instanceof SQLException) {
                return this.onSQLException((SQLException)ex, response);
            }
            if (!(ex instanceof EncryptorException)) continue;
            return this.onEncryptorException((EncryptorException)ex, response);
        }
        response.setException(throwable);
        this.log.error("Error: {}", (Object)throwable.getMessage());
        return response;
    }

    private Response onAuthorizationException(AuthorizationException e, Response response) {
        HashMap<String, String> report = new HashMap<String, String>();
        String title = I18n.get("Access error");
        String message = e.getMessage();
        report.put("title", title);
        report.put("message", message);
        response.setData(report);
        if (e instanceof UnauthenticatedException) {
            response.setStatus(Response.STATUS_LOGIN_REQUIRED);
        } else {
            response.setStatus(Response.STATUS_FAILURE);
        }
        this.log.error("Authorization Error: {}", (Object)e.getMessage());
        return response;
    }

    private Response onAuthSecurityException(AuthSecurityException e, Response response) {
        this.log.error("Access Error: {}", (Object)e.getMessage());
        return e.getType() == JpaSecurity.AccessType.READ ? response : response.fail(e.getMessage());
    }

    private Response onOptimisticLockException(OptimisticLockException e, Response response) {
        HashMap<String, String> report = new HashMap<String, String>();
        String title = I18n.get("Concurrent updates error");
        String message = I18n.get("Record was updated or deleted by another transaction");
        Object entity = e.getEntity();
        if (entity instanceof Model) {
            message = message + " : [" + entity.getClass().getSimpleName() + "{id:" + ((Model)entity).getId() + "}]";
        }
        report.put("title", title);
        report.put("message", message);
        response.setData(report);
        response.setStatus(Response.STATUS_FAILURE);
        this.log.error("Concurrency Error: {}", (Object)e.getMessage());
        return response;
    }

    private Response onConstraintViolationException(ConstraintViolationException e, Response response) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> report = new HashMap<String, String>();
        for (ConstraintViolation cv : e.getConstraintViolations()) {
            sb.append("    &#8226; [").append(cv.getPropertyPath()).append("] - ");
            sb.append(cv.getMessage()).append("\n");
        }
        report.put("title", I18n.get("Validation error"));
        report.put("message", sb.toString());
        response.setData(report);
        response.setStatus(Response.STATUS_FAILURE);
        this.log.error("Constraint Error: {}", (Object)e.getMessage());
        return response;
    }

    private Response onEncryptorException(EncryptorException e, Response response) {
        Throwable cause = e.getCause();
        HashMap<String, String> report = new HashMap<String, String>();
        String message = e.getMessage();
        if (cause instanceof BadPaddingException) {
            message = I18n.get("Encryption key might be wrong.");
        }
        report.put("title", I18n.get("Encryption error"));
        report.put("message", message);
        this.log.error("Encryption Error: {}", (Object)e.getMessage(), (Object)e);
        response.setData(report);
        response.setStatus(Response.STATUS_FAILURE);
        return response;
    }

    private Response onSQLException(SQLException e, Response response) {
        if (!(e instanceof PSQLException)) {
            response.setException(e);
            return response;
        }
        String state = e.getSQLState();
        if (state == null) {
            state = "";
        }
        PSQLException pe = (PSQLException)e;
        String title = null;
        String message = pe.getServerErrorMessage().getMessage();
        switch (state) {
            case "23503": {
                title = I18n.get("Reference error");
                message = I18n.get("The record(s) are referenced by other records, please remove all the references first.");
                break;
            }
            case "23505": {
                title = I18n.get("Unique constraint violation");
                message = I18n.get("The record(s) can't be updated as it violates unique constraint.");
                break;
            }
            default: {
                title = I18n.get("SQL error");
                message = I18n.get("Unexpected database error occurred on the server.");
            }
        }
        if (AuthUtils.isAdmin(AuthUtils.getUser()) || AuthUtils.isTechnicalStaff(AuthUtils.getUser())) {
            message = message + "<p>" + pe.getMessage() + "</p>";
        }
        HashMap<String, String> report = new HashMap<String, String>();
        report.put("title", title);
        report.put("message", message);
        response.setData(report);
        response.setStatus(Response.STATUS_FAILURE);
        this.log.error("SQL Error: {}", (Object)e.getMessage());
        return response;
    }
}

