/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.common.StringUtils;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.i18n.I18n;
import java.util.Collection;
import java.util.Map;

final class Translator {
    private Translator() {
    }

    private static String getTranslation(Property property, String value) {
        String key;
        String val;
        if (property.isTranslatable() && StringUtils.notBlank((CharSequence)value) && (val = I18n.get(key = "value:" + value)) != key) {
            return val;
        }
        return value;
    }

    private static String toKey(String name) {
        return String.format("$t:%s", name);
    }

    static Map<String, Object> translate(Map<String, Object> values, Property property) {
        String val;
        String name = property.getName();
        Object value = values.get(name);
        if (value instanceof String && (val = Translator.getTranslation(property, (String)value)) != value) {
            values.put(Translator.toKey(name), val);
        }
        return values;
    }

    static void applyTranslatables(Map<String, Object> values, Class<?> model) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Mapper mapper = Mapper.of(model);
        for (Property property : mapper.getProperties()) {
            String name = property.getName();
            Object value = values.get(name);
            if (property.isTranslatable() && value instanceof String) {
                Translator.translate(values, property);
            }
            if (property.getTarget() != null && value instanceof Map) {
                Translator.applyTranslatables((Map)value, property.getTarget());
            }
            if (property.getTarget() == null || !(value instanceof Collection)) continue;
            for (Object item : (Collection)value) {
                if (!(item instanceof Map)) continue;
                Translator.applyTranslatables((Map)item, property.getTarget());
            }
        }
    }
}

