/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc.filter;

import com.axelor.db.internal.DBHelper;
import com.axelor.rpc.filter.Operator;
import com.axelor.rpc.filter.SimpleFilter;

class LikeFilter
extends SimpleFilter {
    private LikeFilter(Operator operator, String fieldName, String value) {
        super(operator, fieldName, value);
    }

    private static String format(Object value) {
        String text = value.toString().toUpperCase();
        if (text.matches("(^%.*)|(.*%$)")) {
            return text;
        }
        text = "%" + text + "%";
        return text;
    }

    public static LikeFilter like(String fieldName, Object value) {
        return new LikeFilter(Operator.LIKE, fieldName, LikeFilter.format(value));
    }

    public static LikeFilter notLike(String fieldName, Object value) {
        return new LikeFilter(Operator.NOT_LIKE, fieldName, LikeFilter.format(value));
    }

    @Override
    public String getQuery() {
        if (DBHelper.isUnaccentEnabled()) {
            return String.format("(unaccent(UPPER(%s)) %s unaccent(?))", new Object[]{this.getOperand(), this.getOperator()});
        }
        return String.format("(UPPER(%s) %s ?)", new Object[]{this.getOperand(), this.getOperator()});
    }
}

