/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc.filter;

import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.Operator;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;

class LogicalFilter
extends Filter {
    private Operator operator;
    private List<Filter> filters;

    public LogicalFilter(Operator operator, List<Filter> filters) {
        this.operator = operator;
        this.filters = filters;
    }

    @Override
    public String getQuery() {
        if (this.filters == null || this.filters.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.operator == Operator.NOT) {
            sb.append("NOT ");
        }
        if (this.filters.size() > 1) {
            sb.append("(");
        }
        String joiner = this.operator == Operator.NOT ? " AND " : " " + this.operator.name() + " ";
        sb.append(Joiner.on((String)joiner).join(this.filters));
        if (this.filters.size() > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<Object> getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Filter filter : this.filters) {
            params.addAll(filter.getParams());
        }
        return params;
    }
}

