/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc.filter;

import com.axelor.rpc.filter.Operator;
import com.axelor.rpc.filter.SimpleFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class RangeFilter
extends SimpleFilter {
    private Collection<?> values;

    public RangeFilter(Operator operator, String fieldName, Object value) {
        super(operator, fieldName, value);
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException();
        }
        this.values = (Collection)value;
    }

    @Override
    public String getQuery() {
        if (this.getOperator() == Operator.BETWEEN || this.getOperator() == Operator.NOT_BETWEEN) {
            return String.format("(%s %s ? AND ?)", new Object[]{this.getOperand(), this.getOperator()});
        }
        StringBuilder sb = new StringBuilder(this.getOperand());
        sb.append(" ").append((Object)this.getOperator()).append(" (");
        Iterator<?> iter = this.values.iterator();
        iter.next();
        sb.append("?");
        while (iter.hasNext()) {
            sb.append(", ").append("?");
            iter.next();
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<Object> getParams() {
        return new ArrayList<Object>(this.values);
    }
}

