/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc.filter;

import com.axelor.db.hibernate.type.JsonFunction;
import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.Operator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;

class SimpleFilter
extends Filter {
    private static Pattern NAME_PATTERN = Pattern.compile("\\w+(\\.\\w+)*");
    private String fieldName;
    private Operator operator;
    private Object value;

    public SimpleFilter(Operator operator, String fieldName, Object value) {
        this.fieldName = fieldName;
        this.operator = operator;
        this.value = value;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    protected String getOperand() {
        String name = this.getFieldName();
        if (name.indexOf("::") > -1) {
            return JsonFunction.fromPath(name).toString();
        }
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new PersistenceException("Invalid field name: " + name);
        }
        return "self." + name;
    }

    @Override
    public String getQuery() {
        return String.format("(%s %s ?)", new Object[]{this.getOperand(), this.operator});
    }

    @Override
    public List<Object> getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.value);
        return params;
    }
}

