/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.script;

import com.axelor.common.StringUtils;
import com.axelor.rpc.Context;
import com.axelor.script.AbstractScriptHelper;
import com.axelor.script.ELScriptHelper;
import com.axelor.script.GroovyScriptHelper;
import com.axelor.script.ScriptBindings;
import com.axelor.script.ScriptHelper;
import javax.script.Bindings;

public class CompositeScriptHelper
extends AbstractScriptHelper {
    private GroovyScriptHelper gsh;
    private ELScriptHelper esh;

    public CompositeScriptHelper(Bindings bindings) {
        this.setBindings(bindings);
    }

    public CompositeScriptHelper(Context context) {
        this(new ScriptBindings(context));
    }

    private ScriptHelper getGSH() {
        if (this.gsh == null) {
            this.gsh = new GroovyScriptHelper(this.getBindings());
        }
        return this.gsh;
    }

    private ScriptHelper getESH() {
        if (this.esh == null) {
            this.esh = new ELScriptHelper(this.getBindings());
        }
        return this.esh;
    }

    private String strip(String expr) {
        String str = expr.trim();
        return str.substring(2, str.length() - 1);
    }

    private boolean isEL(String expr) {
        if (StringUtils.isBlank((CharSequence)expr)) {
            return true;
        }
        String str = expr.trim();
        return str.startsWith("#{") && str.endsWith("}");
    }

    @Override
    public Object call(Object obj, String methodCall) {
        return this.getESH().call(obj, methodCall);
    }

    @Override
    protected Object doCall(Object obj, String methodCall) {
        return null;
    }

    @Override
    public Object eval(String expr, Bindings bindings) throws Exception {
        return this.isEL(expr) ? this.getESH().eval(this.strip(expr), bindings) : this.getGSH().eval(expr, bindings);
    }
}

