/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.script;

import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.JpaScanner;
import com.axelor.db.Model;
import com.axelor.db.Repository;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.Query;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.JSObject;

class NashornGlobals
extends SimpleBindings {
    private static final Class<?>[] DEFAULT_TYPES = new Class[]{Beans.class, Model.class, Query.class, Repository.class, LocalDate.class, LocalDateTime.class, LocalTime.class, ZonedDateTime.class, HashMap.class, HashSet.class, ArrayList.class, BigDecimal.class, MathContext.class, System.class, Arrays.class};
    private JSObject typeFunction;
    private final ScriptEngine engine;

    public NashornGlobals(ScriptEngine engine) {
        this.engine = engine;
        this.put("__repo__", t -> JpaRepository.of(t));
        this.put("doInJPA", task -> {
            Preconditions.checkArgument((boolean)task.isFunction(), (Object)"doInJPA expectes function argument");
            Object[] result = new Object[]{null};
            JPA.runInTransaction(() -> {
                result[0] = task.call(null, new Object[]{JPA.em()});
            });
            return result[0];
        });
        this.put("listOf", args -> new ArrayList<Object>(Arrays.asList(args)));
        this.put("setOf", args -> new HashSet<Object>(Arrays.asList(args)));
        this.put("mapOf", obj -> {
            if (obj.isArray()) {
                throw new IllegalArgumentException("mapOf expectes object literal as argument");
            }
            return new HashMap(obj);
        });
    }

    private JSObject typeFunction() {
        if (this.typeFunction == null) {
            try {
                this.typeFunction = (JSObject)this.engine.eval("Java.type");
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        }
        return this.typeFunction;
    }

    private Class<?> findClass(String simpleName) {
        if (StringUtils.isBlank((CharSequence)simpleName) || !Character.isUpperCase(simpleName.charAt(0))) {
            return null;
        }
        Class<?> found = Arrays.stream(DEFAULT_TYPES).filter(c -> c.getSimpleName().equals(simpleName)).findFirst().orElse(null);
        if (found == null) {
            found = JpaScanner.findModel(simpleName);
        }
        if (found == null) {
            found = JpaScanner.findRepository(simpleName);
        }
        return found;
    }

    @Override
    public Object get(Object key) {
        if (super.containsKey(key)) {
            return super.get(key);
        }
        Object value = super.get(key);
        if (value == null && key instanceof String) {
            Class<?> klass = this.findClass((String)key);
            return klass == null ? null : this.typeFunction().call(null, new Object[]{klass.getName()});
        }
        return value;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean contains = super.containsKey(key);
        if (contains || !(key instanceof String)) {
            return contains;
        }
        return this.findClass((String)key) != null;
    }

    @FunctionalInterface
    public static interface VarArgs {
        public Object apply(Object ... var1);
    }
}

