/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.script;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.rpc.Context;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.script.SimpleBindings;

public class ScriptBindings
extends SimpleBindings {
    private static final String MODEL_KEY = "_model";
    private static final Set<String> META_VARS = ImmutableSet.of((Object)"__id__", (Object)"__ids__", (Object)"__this__", (Object)"__self__", (Object)"__user__", (Object)"__ref__", (Object[])new String[]{"__parent__", "__date__", "__time__", "__datetime__", "__config__"});
    private Map<String, Object> variables;
    private Map<String, Object> configContext;

    public ScriptBindings(Map<String, Object> variables) {
        this.variables = this.tryContext(variables);
    }

    private Map<String, Object> tryContext(Map<String, Object> variables) {
        if (variables == null) {
            return new HashMap<String, Object>();
        }
        if (variables.isEmpty() || variables instanceof Context) {
            return variables;
        }
        try {
            String klassName = (String)variables.get(MODEL_KEY);
            if (StringUtils.isBlank((CharSequence)klassName)) {
                return variables;
            }
            return new Context(variables, Class.forName((String)variables.get(MODEL_KEY)));
        }
        catch (ClassNotFoundException e) {
            return variables;
        }
    }

    private Object getSpecial(String name) throws Exception {
        switch (name) {
            case "__id__": {
                if (this.variables.containsKey("id")) {
                    return Longs.tryParse((String)this.variables.get("id").toString());
                }
                if (this.variables.containsKey("_id")) {
                    return Longs.tryParse((String)this.variables.get("_id").toString());
                }
                return ((Context)this.variables).asType(Model.class).getId();
            }
            case "__ids__": {
                return this.variables.get("_ids");
            }
            case "__this__": {
                return ((Context)this.variables).asType(Model.class);
            }
            case "__parent__": {
                return ((Context)this.variables).getParent();
            }
            case "__date__": {
                return LocalDate.now();
            }
            case "__time__": {
                return LocalDateTime.now();
            }
            case "__datetime__": {
                return ZonedDateTime.now();
            }
            case "__config__": {
                if (this.configContext == null) {
                    this.configContext = new ConfigContext();
                }
                return this.configContext;
            }
            case "__user__": {
                return AuthUtils.getUser();
            }
            case "__self__": {
                Model bean = ((Context)this.variables).asType(Model.class);
                if (bean == null || bean.getId() == null) {
                    return null;
                }
                return JPA.em().getReference(EntityHelper.getEntityClass(bean), (Object)bean.getId());
            }
            case "__ref__": {
                Map values = (Map)this.variables.get("_ref");
                Class<?> klass = Class.forName((String)values.get(MODEL_KEY));
                return JPA.em().getReference(klass, (Object)Long.parseLong(values.get("id").toString()));
            }
        }
        return null;
    }

    public <T> T asType(Class<T> type) {
        Preconditions.checkState((boolean)(this.variables instanceof Context), (Object)"Invalid binding, only Context bindings can be converted.");
        return ((Context)this.variables).asType(type);
    }

    @Override
    public boolean containsKey(Object key) {
        return META_VARS.contains(key) || super.containsKey(key) || this.variables.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        HashSet keys = Sets.newHashSet(super.keySet());
        keys.addAll(this.variables.keySet());
        keys.addAll(META_VARS);
        return keys;
    }

    @Override
    public Object get(Object key) {
        if (super.containsKey(key)) {
            return super.get(key);
        }
        if (this.variables.containsKey(key)) {
            return this.variables.get(key);
        }
        if (META_VARS.contains(key)) {
            String name = key.toString();
            Object value = null;
            try {
                value = this.getSpecial(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.put(name, value);
            return value;
        }
        return null;
    }

    @Override
    public Object put(String name, Object value) {
        if (META_VARS.contains(name) || name.startsWith("$") || name.startsWith("__")) {
            return super.put(name, value);
        }
        return this.variables.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        HashMap values = Maps.newHashMap();
        for (String string : toMerge.keySet()) {
            Object value = toMerge.get(string);
            if (META_VARS.contains(string)) {
                this.put(string, value);
                continue;
            }
            values.put(string, values);
        }
        this.variables.putAll(values);
    }

    static class ConfigContext
    extends HashMap<String, Object> {
        private static Map<String, String> CONFIG;
        private Map<String, Object> values = new HashMap<String, Object>();

        public ConfigContext() {
            if (CONFIG == null) {
                CONFIG = new HashMap<String, String>();
                Properties properties = AppSettings.get().getProperties();
                for (Object item : properties.keySet()) {
                    String name = item.toString();
                    String expr = properties.getProperty(name);
                    if (!name.startsWith("context.") || StringUtils.isBlank((CharSequence)expr)) continue;
                    CONFIG.put(name.substring(8), expr);
                }
            }
        }

        @Override
        public Set<String> keySet() {
            return CONFIG.keySet();
        }

        @Override
        public boolean containsKey(Object key) {
            return CONFIG.containsKey(key);
        }

        @Override
        public Object get(Object key) {
            if (this.values.containsKey(key) || !this.containsKey(key)) {
                return this.values.get(key);
            }
            String name = (String)key;
            String expr = CONFIG.get(key);
            String[] parts = expr.split("\\:", 2);
            Object invalid = new Object();
            Class<?> klass = null;
            Object value = invalid;
            try {
                klass = Class.forName(parts[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (klass == null) {
                value = this.adapt(expr);
                this.values.put(name, value);
                return value;
            }
            try {
                value = klass.getField(parts[1]).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                value = klass.getMethod(parts[1], new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value != invalid) {
                this.values.put(name, value);
                return value;
            }
            Object instance = Beans.get(klass);
            if (parts.length == 1) {
                value = instance;
                this.values.put(name, value);
                return value;
            }
            try {
                value = klass.getMethod(parts[1], new Class[0]).invoke(instance, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == invalid) {
                throw new RuntimeException("Invalid configuration: " + name + " = " + expr);
            }
            this.values.put(name, value);
            return value;
        }

        private Object adapt(String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            if ("true".equals(value.toLowerCase())) {
                return true;
            }
            if ("false".equals(value.toLowerCase())) {
                return false;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                return value;
            }
        }
    }
}

