/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.team.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="TEAM_TOPIC", indexes={@Index(columnList="name"), @Index(columnList="team")})
@Track(fields={@TrackField(name="name")}, messages={@TrackMessage(message="Topic created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Topic closed", condition="!active", on={TrackEvent.UPDATE}, fields={"active"}), @TrackMessage(message="Topic re-opened", condition="active", on={TrackEvent.UPDATE}, fields={"active"})}, contents={@TrackMessage(message="#{description}", condition="true", fields={"description"})}, subscribe=true)
public class TeamTopic
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TEAM_TOPIC_SEQ")
    @SequenceGenerator(name="TEAM_TOPIC_SEQ", sequenceName="TEAM_TOPIC_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    private String name;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    private Boolean active = Boolean.TRUE;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TeamTopic() {
    }

    public TeamTopic(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getActive() {
        return this.active == null ? Boolean.FALSE : this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TeamTopic)) {
            return false;
        }
        TeamTopic other = (TeamTopic)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("active", (Object)this.getActive()).omitNullValues().toString();
    }
}

