/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.team.web;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.JpaSupport;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Response;
import java.util.Arrays;
import java.util.HashMap;
import javax.persistence.TypedQuery;

public class TaskController
extends JpaSupport {
    private static final String SQL_TASKS_DUE = "SELECT tt FROM TeamTask tt LEFT JOIN tt.assignedTo u WHERE \t(tt.status NOT IN :closed_status AND u.id = :uid) AND  (tt.taskDeadline <= current_date)";
    private static final String SQL_TASKS_TODO = "SELECT tt FROM TeamTask tt LEFT JOIN tt.assignedTo u WHERE \t(tt.status NOT IN :closed_status AND u.id = :uid) AND \t(tt.taskDeadline <= current_date OR tt.taskDate <= current_date)";

    public void countTasks(ActionRequest request, ActionResponse response) {
        HashMap<String, Long> value = new HashMap<String, Long>();
        value.put("pending", this.countTasks(SQL_TASKS_DUE));
        value.put("current", this.countTasks(SQL_TASKS_TODO));
        response.setValue("tasks", value);
        response.setStatus(Response.STATUS_SUCCESS);
    }

    private Long countTasks(String queryString) {
        User user = AuthUtils.getUser();
        if (user == null) {
            return 0L;
        }
        String countString = queryString.replace("SELECT tt FROM TeamTask tt", "SELECT COUNT(tt.id) FROM TeamTask tt");
        TypedQuery query = this.getEntityManager().createQuery(countString, Long.class);
        query.setParameter("uid", (Object)user.getId());
        query.setParameter("closed_status", Arrays.asList("closed", "canceled"));
        try {
            return (Long)query.getSingleResult();
        }
        catch (Exception exception) {
            return 0L;
        }
    }
}

