/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.text;

import com.axelor.common.StringUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.MetaStore;
import com.axelor.text.Renderer;
import com.axelor.text.Template;
import com.axelor.text.Templates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.xml.XmlEscapers;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.compiler.Bytecode;
import org.stringtemplate.v4.misc.ObjectModelAdaptor;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;

public class StringTemplates
implements Templates {
    private static final char DEFAULT_START_DELIMITER = '<';
    private static final char DEFAULT_STOP_DELIMITER = '>';
    private final STGroup group;

    public StringTemplates() {
        this('<', '>');
    }

    public StringTemplates(char delimiterStartChar, char delimiterStopChar) {
        this.group = new STGroup(delimiterStartChar, delimiterStopChar);
        this.group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        this.group.registerModelAdaptor(Object.class, (ModelAdaptor)new DataAdapter());
    }

    @Override
    public Template fromText(String text) {
        ST template = new ST(this.group, text);
        return new StringTemplate(template);
    }

    @Override
    public Template from(File file) throws IOException {
        return this.from(new FileReader(file));
    }

    @Override
    public Template from(Reader reader) throws IOException {
        return this.fromText(CharStreams.toString((Readable)reader));
    }

    private String valueOf(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    private String getSelectionTitle(String name, Object value) {
        String val = this.valueOf(value);
        if (StringUtils.isBlank((CharSequence)val)) {
            return val;
        }
        try {
            return MetaStore.getSelectionItem(name, val).getLocalizedTitle();
        }
        catch (Exception exception) {
            return val;
        }
    }

    class StringTemplate
    implements Template {
        private ST template;
        private Set<String> names;

        private StringTemplate(ST template) {
            this.template = template;
            this.names = this.findAttributes();
        }

        private Set<String> findAttributes() {
            HashSet names = Sets.newHashSet();
            int ip = 0;
            while (ip < this.template.impl.codeSize) {
                byte opcode = this.template.impl.instrs[ip];
                Bytecode.Instruction I = Bytecode.instructions[opcode];
                ++ip;
                for (int opnd = 0; opnd < I.nopnds; ++opnd) {
                    int nameIndex;
                    if (opcode == 2 && (nameIndex = Interpreter.getShort((byte[])this.template.impl.instrs, (int)ip)) < this.template.impl.strings.length) {
                        names.add(this.template.impl.strings[nameIndex]);
                    }
                    ip += 2;
                }
            }
            return names;
        }

        @Override
        public Renderer make(Map<String, Object> context) {
            for (String name : this.names) {
                try {
                    this.template.add(name, context.get(name));
                }
                catch (Exception exception) {}
            }
            return new Renderer(){

                @Override
                public void render(Writer out) throws IOException {
                    try {
                        StringTemplate.this.template.write((STWriter)new AutoIndentWriter(out));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        }

        @Override
        public <T extends Model> Renderer make(T context) {
            HashMap ctx = Maps.newHashMap();
            if (context != null) {
                Mapper mapper = Mapper.of(EntityHelper.getEntityClass(context));
                for (String name : this.names) {
                    Property property = mapper.getProperty(name);
                    if (property == null) continue;
                    ctx.put(name, property.get(context));
                }
            }
            return this.make((T)((Object)ctx));
        }
    }

    class DataAdapter
    extends ObjectModelAdaptor {
        DataAdapter() {
        }

        public Object getProperty(Interpreter interp, ST self, Object o, Object property, String propertyName) throws STNoSuchPropertyException {
            if (!(o instanceof Model)) {
                return super.getProperty(interp, self, o, property, propertyName);
            }
            Mapper mapper = Mapper.of(EntityHelper.getEntityClass(o));
            Property field = mapper.getProperty(propertyName);
            if (field == null) {
                return null;
            }
            if (StringUtils.isBlank((CharSequence)field.getSelection())) {
                return field.get(o);
            }
            return StringTemplates.this.getSelectionTitle(field.getSelection(), field.get(o));
        }
    }

    class StringRenderer
    implements AttributeRenderer {
        StringRenderer() {
        }

        public String toString(Object o, String formatString, Locale locale) {
            if (o == null) {
                return "";
            }
            if (formatString == null) {
                return o.toString();
            }
            if (formatString.equals("escape")) {
                return XmlEscapers.xmlAttributeEscaper().escape(o.toString());
            }
            if (formatString.startsWith("selection:")) {
                return StringTemplates.this.getSelectionTitle(formatString.substring(10).trim(), o.toString());
            }
            return o.toString();
        }
    }
}

